/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.weaviate.WeaviateVectorDbComponent;

/**
 * Perform operations on the Weaviate Vector Database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface WeaviateComponentBuilderFactory {

    /**
     * weaviate (camel-weaviate)
     * Perform operations on the Weaviate Vector Database.
     * 
     * Category: database,ai
     * Since: 4.12
     * Maven coordinates: org.apache.camel:camel-weaviate
     * 
     * @return the dsl builder
     */
    static WeaviateComponentBuilder weaviate() {
        return new WeaviateComponentBuilderImpl();
    }

    /**
     * Builder for the weaviate component.
     */
    interface WeaviateComponentBuilder extends ComponentBuilder<WeaviateVectorDbComponent> {
    
        /**
         * API Key to authenticate to weaviate with.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    
        /**
         * The configuration;.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder configuration(org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * Weaviate server host to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder host(java.lang.String host) {
            doSetProperty("host", host);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * Proxy host to connect to weaviate through.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder proxyHost(java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
    
        /**
         * Proxy port to connect to weaviate through.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder proxyPort(java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
    
        /**
         * Proxy scheme to connect to weaviate through.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyScheme the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder proxyScheme(java.lang.String proxyScheme) {
            doSetProperty("proxyScheme", proxyScheme);
            return this;
        }
    
        /**
         * Scheme used to connect to weaviate.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param scheme the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder scheme(java.lang.String scheme) {
            doSetProperty("scheme", scheme);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default WeaviateComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }

    class WeaviateComponentBuilderImpl
            extends AbstractComponentBuilder<WeaviateVectorDbComponent>
            implements WeaviateComponentBuilder {
        @Override
        protected WeaviateVectorDbComponent buildConcreteComponent() {
            return new WeaviateVectorDbComponent();
        }
        private org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration getOrCreateConfiguration(WeaviateVectorDbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "apiKey": getOrCreateConfiguration((WeaviateVectorDbComponent) component).setApiKey((java.lang.String) value); return true;
            case "configuration": ((WeaviateVectorDbComponent) component).setConfiguration((org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration) value); return true;
            case "host": getOrCreateConfiguration((WeaviateVectorDbComponent) component).setHost((java.lang.String) value); return true;
            case "lazyStartProducer": ((WeaviateVectorDbComponent) component).setLazyStartProducer((boolean) value); return true;
            case "proxyHost": getOrCreateConfiguration((WeaviateVectorDbComponent) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((WeaviateVectorDbComponent) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyScheme": getOrCreateConfiguration((WeaviateVectorDbComponent) component).setProxyScheme((java.lang.String) value); return true;
            case "scheme": getOrCreateConfiguration((WeaviateVectorDbComponent) component).setScheme((java.lang.String) value); return true;
            case "autowiredEnabled": ((WeaviateVectorDbComponent) component).setAutowiredEnabled((boolean) value); return true;
            default: return false;
            }
        }
    }
}