/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.io.InputStream;
import junit.framework.Test;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.sftp.AbstractSftpProviderTestCase;
import org.apache.mina.core.session.IoSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.SessionFactory;
import org.junit.jupiter.api.Assertions;

public class SftpPutChannelTestCase
extends AbstractSftpProviderTestCase {
    private static final Integer MAX_CHANNELS = 10;

    public static Test suite() throws Exception {
        return new AbstractSftpProviderTestCase.SftpProviderTestSuite(new SftpPutChannelTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                this.addTests(SftpPutChannelTestCase.class);
            }
        };
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    @Override
    protected boolean isExecChannelClosed() {
        return false;
    }

    @Override
    protected SessionFactory sessionFactory() {
        return new CustomSessionFactory();
    }

    @org.junit.Test
    public void testDoGetInputStream() throws Exception {
        FileObject readFolder = this.getReadFolder();
        for (int i = 0; i < MAX_CHANNELS * 2; ++i) {
            try (InputStream ignored = readFolder.resolveFile("not-exists.txt").getContent().getInputStream();){
                Assertions.fail((String)"file should not be exists");
                continue;
            }
            catch (FileSystemException e) {
                int channelsCount = ((CustomServerSession)((Object)server.getActiveSessions().get(0))).getChannelsCount();
                Assertions.assertTrue((channelsCount < MAX_CHANNELS ? 1 : 0) != 0, (String)("channels count expected less than " + MAX_CHANNELS));
            }
        }
    }

    private static class CustomSessionFactory
    extends SessionFactory {
        private CustomSessionFactory() {
        }

        protected AbstractSession doCreateSession(IoSession ioSession) throws Exception {
            return new CustomServerSession((FactoryManager)this.server, ioSession);
        }
    }

    private static class CustomServerSession
    extends ServerSession {
        public CustomServerSession(FactoryManager server, IoSession ioSession) throws Exception {
            super(server, ioSession);
        }

        public int getChannelsCount() {
            return this.channels.size();
        }
    }
}

