/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import com.google.common.base.Strings;
import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.XMLSignatureBuilder;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Encrypter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(Encrypter.class);
    @Nonnull
    private final Unmarshaller encryptedDataUnmarshaller;
    @Nonnull
    private final Unmarshaller encryptedKeyUnmarshaller;
    @Nonnull
    private final XMLSignatureBuilder<KeyInfo> keyInfoBuilder;
    @Nullable
    private String jcaProviderName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Encrypter() {
        UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        this.encryptedDataUnmarshaller = (Unmarshaller)Constraint.isNotNull((Object)unmarshallerFactory.getUnmarshaller(EncryptedData.DEFAULT_ELEMENT_NAME), (String)"EncryptedData unmarshaller not configured");
        this.encryptedKeyUnmarshaller = (Unmarshaller)Constraint.isNotNull((Object)unmarshallerFactory.getUnmarshaller(EncryptedKey.DEFAULT_ELEMENT_NAME), (String)"EncryptedKey unmarshaller not configured");
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.keyInfoBuilder = (XMLSignatureBuilder)builderFactory.ensureBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
    }

    @Nullable
    public String getJCAProviderName() {
        return this.jcaProviderName;
    }

    public void setJCAProviderName(@Nullable String providerName) {
        this.jcaProviderName = providerName;
    }

    @Nonnull
    public EncryptedData encryptElement(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> emptyKEKParamsList = new ArrayList<KeyEncryptionParameters>();
        return this.encryptElement(xmlObject, encParams, emptyKEKParamsList, false);
    }

    @Nonnull
    public EncryptedData encryptElement(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams, @Nonnull KeyEncryptionParameters kekParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> kekParamsList = new ArrayList<KeyEncryptionParameters>();
        kekParamsList.add(kekParams);
        return this.encryptElement(xmlObject, encParams, kekParamsList, false);
    }

    @Nonnull
    public EncryptedData encryptElement(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams, @Nonnull List<KeyEncryptionParameters> kekParamsList) throws EncryptionException {
        return this.encryptElement(xmlObject, encParams, kekParamsList, false);
    }

    @Nonnull
    public EncryptedData encryptElementContent(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> emptyKEKParamsList = new ArrayList<KeyEncryptionParameters>();
        return this.encryptElement(xmlObject, encParams, emptyKEKParamsList, true);
    }

    @Nonnull
    public EncryptedData encryptElementContent(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams, @Nonnull KeyEncryptionParameters kekParams) throws EncryptionException {
        ArrayList<KeyEncryptionParameters> kekParamsList = new ArrayList<KeyEncryptionParameters>();
        kekParamsList.add(kekParams);
        return this.encryptElement(xmlObject, encParams, kekParamsList, true);
    }

    @Nonnull
    public EncryptedData encryptElementContent(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams, @Nonnull List<KeyEncryptionParameters> kekParamsList) throws EncryptionException {
        return this.encryptElement(xmlObject, encParams, kekParamsList, true);
    }

    @Nonnull
    public List<EncryptedKey> encryptKey(@Nonnull Key key, @Nonnull List<KeyEncryptionParameters> kekParamsList, @Nonnull Document containingDocument) throws EncryptionException {
        this.checkParams(kekParamsList, false);
        ArrayList<EncryptedKey> encKeys = new ArrayList<EncryptedKey>();
        for (KeyEncryptionParameters kekParam : kekParamsList) {
            if (!$assertionsDisabled && kekParam == null) {
                throw new AssertionError();
            }
            encKeys.add(this.encryptKey(key, kekParam, containingDocument));
        }
        return encKeys;
    }

    @Nonnull
    public EncryptedKey encryptKey(@Nonnull Key key, @Nonnull KeyEncryptionParameters kekParams, @Nonnull Document containingDocument) throws EncryptionException {
        Key encryptionKey;
        this.checkParams(kekParams, false);
        Credential encryptionCred = kekParams.getEncryptionCredential();
        Key key2 = encryptionKey = encryptionCred != null ? CredentialSupport.extractEncryptionKey((Credential)encryptionCred) : null;
        if (encryptionKey == null) {
            throw new EncryptionException("Unable to obtain encryption key from parameters");
        }
        String alg = kekParams.getAlgorithm();
        if (!$assertionsDisabled && alg == null) {
            throw new AssertionError();
        }
        EncryptedKey encryptedKey = this.encryptKey(key, encryptionKey, alg, kekParams.getRSAOAEPParameters(), containingDocument);
        KeyInfoGenerator keyInfoGenerator = kekParams.getKeyInfoGenerator();
        if (keyInfoGenerator != null) {
            this.log.debug("Dynamically generating KeyInfo from Credential for EncryptedKey using generator: {}", (Object)keyInfoGenerator.getClass().getName());
            try {
                encryptedKey.setKeyInfo(keyInfoGenerator.generate(kekParams.getEncryptionCredential()));
            }
            catch (SecurityException e) {
                this.log.error("Error during EncryptedKey KeyInfo generation: {}", (Object)e.getMessage());
                throw new EncryptionException("Error during EncryptedKey KeyInfo generation", (Exception)((Object)e));
            }
        }
        if (kekParams.getRecipient() != null) {
            encryptedKey.setRecipient(kekParams.getRecipient());
        }
        return encryptedKey;
    }

    @Nonnull
    protected EncryptedKey encryptKey(@Nonnull Key targetKey, @Nonnull Key encryptionKey, @Nonnull String encryptionAlgorithmURI, @Nullable RSAOAEPParameters rsaOAEPParams, @Nonnull Document containingDocument) throws EncryptionException {
        org.apache.xml.security.encryption.EncryptedKey apacheEncryptedKey;
        XMLCipher xmlCipher;
        Constraint.isNotNull((Object)targetKey, (String)"Target key cannot be null");
        Constraint.isNotNull((Object)encryptionKey, (String)"Encryption key cannot be null");
        Constraint.isNotNull((Object)encryptionAlgorithmURI, (String)"Encryption algorithm URI cannot be null");
        Constraint.isNotNull((Object)containingDocument, (String)"Containing document cannot be null");
        this.log.debug("Encrypting encryption key with algorithm: {}", (Object)encryptionAlgorithmURI);
        try {
            xmlCipher = this.buildXMLCipher(encryptionKey, encryptionAlgorithmURI, rsaOAEPParams);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error initializing cipher instance on key encryption: {}", (Object)e.getMessage());
            throw new EncryptionException("Error initializing cipher instance on key encryption", (Exception)((Object)e));
        }
        try {
            apacheEncryptedKey = AlgorithmSupport.isRSAOAEP(encryptionAlgorithmURI) && rsaOAEPParams != null ? xmlCipher.encryptKey(containingDocument, targetKey, this.getEffectiveMGF(encryptionAlgorithmURI, rsaOAEPParams), this.decodeOAEPParams(rsaOAEPParams.getOAEPParams())) : xmlCipher.encryptKey(containingDocument, targetKey);
            if (!$assertionsDisabled && apacheEncryptedKey == null) {
                throw new AssertionError();
            }
            this.postProcessApacheEncryptedKey(apacheEncryptedKey, targetKey, encryptionKey, encryptionAlgorithmURI, containingDocument);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error encrypting element on key encryption: {}", (Object)e.getMessage());
            throw new EncryptionException("Error encrypting element on key encryption", (Exception)((Object)e));
        }
        try {
            Element encKeyElement = xmlCipher.martial(containingDocument, apacheEncryptedKey);
            if (!$assertionsDisabled && encKeyElement == null) {
                throw new AssertionError();
            }
            return (EncryptedKey)this.encryptedKeyUnmarshaller.unmarshall(encKeyElement);
        }
        catch (UnmarshallingException e) {
            this.log.error("Error unmarshalling EncryptedKey element: {}", (Object)e.getMessage());
            throw new EncryptionException("Error unmarshalling EncryptedKey element");
        }
    }

    @Nonnull
    protected XMLCipher buildXMLCipher(@Nonnull Key encryptionKey, @Nonnull String encryptionAlgorithmURI, @Nullable RSAOAEPParameters rsaOAEPParams) throws XMLEncryptionException {
        XMLCipher xmlCipher = this.getJCAProviderName() != null ? (AlgorithmSupport.isRSAOAEP(encryptionAlgorithmURI) && rsaOAEPParams != null && rsaOAEPParams.getDigestMethod() != null ? XMLCipher.getProviderInstance((String)encryptionAlgorithmURI, (String)this.getJCAProviderName(), (String)null, (String)rsaOAEPParams.getDigestMethod()) : XMLCipher.getProviderInstance((String)encryptionAlgorithmURI, (String)this.getJCAProviderName())) : (AlgorithmSupport.isRSAOAEP(encryptionAlgorithmURI) && rsaOAEPParams != null && rsaOAEPParams.getDigestMethod() != null ? XMLCipher.getInstance((String)encryptionAlgorithmURI, null, (String)rsaOAEPParams.getDigestMethod()) : XMLCipher.getInstance((String)encryptionAlgorithmURI));
        xmlCipher.init(3, encryptionKey);
        return xmlCipher;
    }

    @Nullable
    protected String getEffectiveMGF(@Nonnull String encryptionAlgorithmURI, @Nullable RSAOAEPParameters rsaOAEPParams) {
        if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionAlgorithmURI) && rsaOAEPParams != null) {
            return rsaOAEPParams.getMaskGenerationFunction();
        }
        return null;
    }

    @Nullable
    protected byte[] decodeOAEPParams(@Nullable String base64Params) throws EncryptionException {
        try {
            if (base64Params != null) {
                byte[] oaepParams = Base64Support.decode((String)base64Params);
                if (oaepParams.length == 0) {
                    return null;
                }
                return oaepParams;
            }
            return null;
        }
        catch (DecodingException e) {
            throw new EncryptionException(String.format("Error decoding OAEPParams data '%s'", base64Params), (Exception)((Object)e));
        }
    }

    protected void postProcessApacheEncryptedKey(@Nonnull org.apache.xml.security.encryption.EncryptedKey apacheEncryptedKey, @Nonnull Key targetKey, @Nonnull Key encryptionKey, @Nonnull String encryptionAlgorithmURI, @Nonnull Document containingDocument) throws EncryptionException {
        if (AlgorithmSupport.isRSAOAEP(encryptionAlgorithmURI)) {
            EncryptionMethod apacheEncryptionMethod = apacheEncryptedKey.getEncryptionMethod();
            if (apacheEncryptionMethod.getDigestAlgorithm() == null) {
                apacheEncryptionMethod.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
            }
            if (!"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(encryptionAlgorithmURI) && apacheEncryptionMethod.getMGFAlgorithm() == null) {
                apacheEncryptionMethod.setMGFAlgorithm("http://www.w3.org/2009/xmlenc11#mgf1sha1");
            }
        }
    }

    @Nonnull
    protected EncryptedData encryptElement(@Nonnull XMLObject xmlObject, @Nonnull Key encryptionKey, @Nonnull String encryptionAlgorithmURI, boolean encryptContentMode) throws EncryptionException {
        org.apache.xml.security.encryption.EncryptedData apacheEncryptedData;
        XMLCipher xmlCipher;
        this.log.debug("Encrypting XMLObject using algorithm URI {} with content mode {}", (Object)encryptionAlgorithmURI, (Object)encryptContentMode);
        this.checkAndMarshall(xmlObject);
        Element targetElement = xmlObject.getDOM();
        if (!$assertionsDisabled && targetElement == null) {
            throw new AssertionError();
        }
        Document ownerDocument = targetElement.getOwnerDocument();
        try {
            xmlCipher = this.getJCAProviderName() != null ? XMLCipher.getProviderInstance((String)encryptionAlgorithmURI, (String)this.getJCAProviderName()) : XMLCipher.getInstance((String)encryptionAlgorithmURI);
            xmlCipher.init(1, encryptionKey);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error initializing cipher instance on XMLObject encryption: {}", (Object)e.getMessage());
            throw new EncryptionException("Error initializing cipher instance", (Exception)((Object)e));
        }
        try {
            apacheEncryptedData = xmlCipher.encryptData(ownerDocument, targetElement, encryptContentMode);
        }
        catch (Exception e) {
            this.log.error("Error encrypting XMLObject: {}", (Object)e.getMessage());
            throw new EncryptionException("Error encrypting XMLObject", e);
        }
        try {
            Element encDataElement = xmlCipher.martial(ownerDocument, apacheEncryptedData);
            if (!$assertionsDisabled && encDataElement == null) {
                throw new AssertionError();
            }
            return (EncryptedData)this.encryptedDataUnmarshaller.unmarshall(encDataElement);
        }
        catch (UnmarshallingException e) {
            this.log.error("Error unmarshalling EncryptedData element: {}", (Object)e.getMessage());
            throw new EncryptionException("Error unmarshalling EncryptedData element", (Exception)((Object)e));
        }
    }

    @Nonnull
    private EncryptedData encryptElement(@Nonnull XMLObject xmlObject, @Nonnull DataEncryptionParameters encParams, @Nonnull List<KeyEncryptionParameters> kekParamsList, boolean encryptContentMode) throws EncryptionException {
        Key encryptionKey;
        this.checkParams(encParams, kekParamsList);
        String encryptionAlgorithmURI = encParams.getAlgorithm();
        if (!$assertionsDisabled && encryptionAlgorithmURI == null) {
            throw new AssertionError();
        }
        Credential encryptionCred = encParams.getEncryptionCredential();
        Key key = encryptionKey = encryptionCred != null ? CredentialSupport.extractEncryptionKey((Credential)encryptionCred) : null;
        if (encryptionKey == null) {
            encryptionKey = this.generateEncryptionKey(encryptionAlgorithmURI);
        }
        EncryptedData encryptedData = this.encryptElement(xmlObject, encryptionKey, encryptionAlgorithmURI, encryptContentMode);
        Element domNode = encryptedData.getDOM();
        if (!$assertionsDisabled && domNode == null) {
            throw new AssertionError();
        }
        Document ownerDocument = domNode.getOwnerDocument();
        if (!$assertionsDisabled && ownerDocument == null) {
            throw new AssertionError();
        }
        KeyInfoGenerator keyInfoGenerator = encParams.getKeyInfoGenerator();
        if (keyInfoGenerator != null) {
            this.log.debug("Dynamically generating KeyInfo from Credential for EncryptedData using generator: {}", (Object)keyInfoGenerator.getClass().getName());
            try {
                encryptedData.setKeyInfo(keyInfoGenerator.generate(encParams.getEncryptionCredential()));
            }
            catch (SecurityException e) {
                this.log.error("Error during EncryptedData KeyInfo generation: {}", (Object)e.getMessage());
                throw new EncryptionException("Error during EncryptedData KeyInfo generation", (Exception)((Object)e));
            }
        }
        for (KeyEncryptionParameters kekParams : kekParamsList) {
            if (!$assertionsDisabled && kekParams == null) {
                throw new AssertionError();
            }
            EncryptedKey encryptedKey = this.encryptKey(encryptionKey, kekParams, ownerDocument);
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = this.keyInfoBuilder.buildObject();
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.getEncryptedKeys().add(encryptedKey);
        }
        return encryptedData;
    }

    protected void checkAndMarshall(@Nonnull XMLObject xmlObject) throws EncryptionException {
        Element targetElement = xmlObject.getDOM();
        if (targetElement == null) {
            try {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(xmlObject);
                if (marshaller == null) {
                    throw new MarshallingException("No marshaller available for " + String.valueOf(xmlObject.getElementQName()));
                }
                targetElement = marshaller.marshall(xmlObject);
            }
            catch (MarshallingException e) {
                this.log.error("Error marshalling target XMLObject: {}", (Object)e.getMessage());
                throw new EncryptionException("Error marshalling target XMLObject", (Exception)((Object)e));
            }
        }
    }

    protected void checkParams(@Nonnull DataEncryptionParameters encParams) throws EncryptionException {
        if (Strings.isNullOrEmpty((String)encParams.getAlgorithm())) {
            this.log.error("Data encryption algorithm URI is required");
            throw new EncryptionException("Data encryption algorithm URI is required");
        }
    }

    protected void checkParams(@Nullable KeyEncryptionParameters kekParams, boolean allowEmpty) throws EncryptionException {
        Key key;
        if (kekParams == null) {
            if (allowEmpty) {
                return;
            }
            this.log.error("Key encryption parameters are required");
            throw new EncryptionException("Key encryption parameters are required");
        }
        Credential encryptionCred = kekParams.getEncryptionCredential();
        Key key2 = key = encryptionCred != null ? CredentialSupport.extractEncryptionKey((Credential)encryptionCred) : null;
        if (key == null) {
            this.log.error("Key encryption credential and contained key are required");
            throw new EncryptionException("Key encryption credential and contained key are required");
        }
        if (key instanceof DSAPublicKey) {
            this.log.error("Attempt made to use DSA key for encrypted key transport");
            throw new EncryptionException("DSA keys may not be used for encrypted key transport");
        }
        if (key instanceof ECPublicKey) {
            this.log.error("Attempt made to use EC key for encrypted key transport");
            throw new EncryptionException("EC keys may not be used for encrypted key transport");
        }
        if (Strings.isNullOrEmpty((String)kekParams.getAlgorithm())) {
            this.log.error("Key encryption algorithm URI is required");
            throw new EncryptionException("Key encryption algorithm URI is required");
        }
    }

    protected void checkParams(@Nullable List<KeyEncryptionParameters> kekParamsList, boolean allowEmpty) throws EncryptionException {
        if (kekParamsList == null || kekParamsList.isEmpty()) {
            if (allowEmpty) {
                return;
            }
            this.log.error("Key encryption parameters list may not be empty");
            throw new EncryptionException("Key encryption parameters list may not be empty");
        }
        for (KeyEncryptionParameters kekParams : kekParamsList) {
            this.checkParams(kekParams, false);
        }
    }

    protected void checkParams(@Nonnull DataEncryptionParameters encParams, @Nullable List<KeyEncryptionParameters> kekParamsList) throws EncryptionException {
        this.checkParams(encParams);
        this.checkParams(kekParamsList, true);
        Credential encryptionCred = encParams.getEncryptionCredential();
        if (!(encryptionCred != null && CredentialSupport.extractEncryptionKey((Credential)encryptionCred) != null || kekParamsList != null && !kekParamsList.isEmpty())) {
            this.log.error("Using a generated encryption key requires a KeyEncryptionParameters object and key encryption key");
            throw new EncryptionException("Using a generated encryption key requires a KeyEncryptionParameters object and key encryption key");
        }
    }

    @Nonnull
    protected SecretKey generateEncryptionKey(@Nonnull String encryptionAlgorithmURI) throws EncryptionException {
        try {
            this.log.debug("Generating random symmetric data encryption key from algorithm URI: {}", (Object)encryptionAlgorithmURI);
            return AlgorithmSupport.generateSymmetricKey(encryptionAlgorithmURI);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Could not generate encryption key, algorithm URI was invalid: " + encryptionAlgorithmURI);
            throw new EncryptionException("Could not generate encryption key, algorithm URI was invalid: " + encryptionAlgorithmURI);
        }
        catch (KeyException e) {
            this.log.error("Could not generate encryption key from algorithm URI: " + encryptionAlgorithmURI);
            throw new EncryptionException("Could not generate encryption key from algorithm URI: " + encryptionAlgorithmURI);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Encrypter.class.desiredAssertionStatus();
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

