/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;

public class NameOfNode
implements NodeName {
    private final NodeInfo node;

    private NameOfNode(NodeInfo node) {
        this.node = node;
    }

    public static NodeName makeName(NodeInfo node) {
        if (node instanceof MutableNodeInfo) {
            return new FingerprintedQName(node.getPrefix(), node.getNamespaceUri(), node.getLocalPart());
        }
        if (node instanceof AbstractVirtualNode) {
            return new NameOfNode(((AbstractVirtualNode)node).getUnderlyingNode());
        }
        return new NameOfNode(node);
    }

    @Override
    public String getPrefix() {
        return this.node.getPrefix();
    }

    @Override
    public NamespaceUri getNamespaceUri() {
        return this.node.getNamespaceUri();
    }

    @Override
    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    @Override
    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    @Override
    public StructuredQName getStructuredQName() {
        return new StructuredQName(this.getPrefix(), this.getNamespaceUri(), this.getLocalPart());
    }

    @Override
    public boolean hasURI(NamespaceUri ns) {
        if (this.node instanceof TinyNodeImpl) {
            return ((TinyNodeImpl)this.node).hasURI(ns);
        }
        return this.node.getNamespaceUri().equals(ns);
    }

    @Override
    public NamespaceBinding getNamespaceBinding() {
        return new NamespaceBinding(this.getPrefix(), this.getNamespaceUri());
    }

    @Override
    public boolean hasFingerprint() {
        return this.node.hasFingerprint();
    }

    @Override
    public int getFingerprint() {
        if (this.hasFingerprint()) {
            return this.node.getFingerprint();
        }
        return -1;
    }

    @Override
    public int obtainFingerprint(NamePool namePool) {
        if (this.node.hasFingerprint()) {
            return this.node.getFingerprint();
        }
        return namePool.allocateFingerprint(this.node.getNamespaceUri(), this.node.getLocalPart());
    }

    public int hashCode() {
        return StructuredQName.computeHashCode(this.getNamespaceUri(), this.getLocalPart());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeName) {
            NodeName n = (NodeName)obj;
            if (this.node.hasFingerprint() && n.hasFingerprint()) {
                return this.node.getFingerprint() == n.getFingerprint();
            }
            return n.getLocalPart().equals(this.node.getLocalPart()) && n.hasURI(this.node.getNamespaceUri());
        }
        return false;
    }

    @Override
    public boolean isIdentical(IdentityComparable other) {
        return other instanceof NodeName && this.equals(other) && this.getPrefix().equals(((NodeName)other).getPrefix());
    }

    @Override
    public int identityHashCode() {
        return this.hashCode() ^ this.getPrefix().hashCode();
    }
}

