/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.EnhancedPluginAdapter;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.apache.felix.webconsole.internal.servlet.SimplePluginAdapter;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class Plugin
implements ServletConfig,
Comparable<Plugin> {
    private final PluginHolder holder;
    private final String label;
    private final ServiceReference<Servlet> serviceReference;
    protected volatile String title;
    protected volatile String category;
    private volatile Servlet consolePlugin;

    public Plugin(PluginHolder holder, ServiceReference<Servlet> serviceReference, String label) {
        this.holder = holder;
        this.serviceReference = serviceReference;
        this.label = label;
        this.title = Util.getStringProperty(this.getServiceReference(), "felix.webconsole.title");
        this.category = Util.getStringProperty(this.getServiceReference(), "felix.webconsole.category");
    }

    public ServiceReference<Servlet> getServiceReference() {
        return this.serviceReference;
    }

    public Bundle getBundle() {
        return this.serviceReference.getBundle();
    }

    public boolean init() {
        Servlet plugin = this.doGetConsolePlugin();
        if (plugin != null) {
            try {
                plugin.init((ServletConfig)this);
            }
            catch (ServletException servletException) {
                // empty catch block
            }
            this.consolePlugin = plugin;
        }
        return this.getConsolePlugin() != null;
    }

    public void dispose() {
        if (this.consolePlugin != null) {
            try {
                this.consolePlugin.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.doUngetConsolePlugin(this.consolePlugin);
            this.consolePlugin = null;
        }
    }

    private Integer getRanking() {
        Object ranking = this.serviceReference.getProperty("service.ranking");
        if (ranking instanceof Integer) {
            return (Integer)ranking;
        }
        return 0;
    }

    @Override
    public int compareTo(Plugin other) {
        int result = this.getLabel().compareTo(other.getLabel());
        if (result == 0) {
            Integer otherRank;
            Integer rank;
            Long id = this.serviceReference != null ? (Long)this.serviceReference.getProperty("service.id") : 0L;
            Long otherId = other.serviceReference != null ? (Long)other.serviceReference.getProperty("service.id") : 0L;
            result = id.compareTo(otherId);
            if (result != 0 && (result = (rank = this.getRanking()).compareTo(otherRank = this.getRanking())) == 0) {
                result = -1 * id.compareTo(otherId);
            }
        }
        return result;
    }

    public String getLabel() {
        return this.label;
    }

    protected PluginHolder getHolder() {
        return this.holder;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCategory() {
        return this.category;
    }

    public Servlet getConsolePlugin() {
        return this.consolePlugin;
    }

    protected boolean isEnabled() {
        return true;
    }

    public String getId() {
        return this.getServiceReference().toString();
    }

    protected Servlet doGetConsolePlugin() {
        Servlet service = (Servlet)this.getHolder().getBundleContext().getService(this.getServiceReference());
        if (service != null) {
            String[] css = Util.toStringArray(this.getServiceReference().getProperty("felix.webconsole.css"));
            if (service instanceof AbstractServlet) {
                return new EnhancedPluginAdapter((AbstractServlet)service, this.getServiceReference(), this.getLabel(), this.getTitle(), css);
            }
            return new SimplePluginAdapter(service, this.serviceReference, this.getLabel(), this.getTitle(), css);
        }
        return null;
    }

    protected void doUngetConsolePlugin(Servlet consolePlugin) {
        try {
            this.getHolder().getBundleContext().ungetService(this.getServiceReference());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public String getInitParameter(String name) {
        Object property = this.getServiceReference().getProperty(name);
        if (property != null && !property.getClass().isArray()) {
            return property.toString();
        }
        return null;
    }

    public Enumeration<String> getInitParameterNames() {
        final String[] keys = this.getServiceReference().getPropertyKeys();
        return new Enumeration<String>(){
            int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < keys.length;
            }

            @Override
            public String nextElement() {
                if (this.hasMoreElements()) {
                    return keys[this.idx++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ServletContext getServletContext() {
        return this.getHolder().getServletContext();
    }

    public String getServletName() {
        return this.getTitle();
    }
}

