/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.util.BeanUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class MethodNodeUtils {
    private MethodNodeUtils() {
    }

    private static void appendTypeName(StringBuilder sb, ClassNode cn) {
        while (cn.isArray()) {
            cn = cn.getComponentType();
            sb.append('[');
        }
        sb.append(cn.getName());
    }

    public static String methodDescriptorWithoutReturnType(MethodNode mNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(mNode.getName()).append(':');
        for (Parameter p : mNode.getParameters()) {
            MethodNodeUtils.appendTypeName(sb, p.getType());
            sb.append(';');
        }
        return sb.toString();
    }

    public static String methodDescriptor(MethodNode mNode) {
        return MethodNodeUtils.methodDescriptor(mNode, false);
    }

    public static String methodDescriptor(MethodNode mNode, boolean pretty) {
        String name = mNode.getName();
        Parameter[] parameters = mNode.getParameters();
        int nParameters = parameters == null ? 0 : parameters.length;
        StringBuilder sb = new StringBuilder(name.length() * 2 + nParameters * 10);
        if (pretty && !mNode.isConstructor()) {
            sb.append(ClassNodeUtils.formatTypeName(mNode.getReturnType()));
            sb.append(' ');
        }
        if (name.contains(" ")) {
            sb.append('\"').append(name).append('\"');
        } else {
            sb.append(name);
        }
        sb.append('(');
        for (int i = 0; i < nParameters; ++i) {
            if (i > 0) {
                sb.append(',');
                if (pretty) {
                    sb.append(' ');
                }
            }
            if (pretty) {
                sb.append(ClassNodeUtils.formatTypeName(parameters[i].getType()));
                continue;
            }
            MethodNodeUtils.appendTypeName(sb, parameters[i].getType());
        }
        sb.append(')');
        if (!pretty && !mNode.isConstructor()) {
            sb.append(':');
            MethodNodeUtils.appendTypeName(sb, mNode.getReturnType());
        }
        return sb.toString();
    }

    public static String getPropertyName(MethodNode mNode) {
        String name = mNode.getName();
        int nameLength = name.length();
        if (nameLength > 2) {
            switch (name.charAt(0)) {
                case 'g': {
                    if (nameLength <= 3 || name.charAt(1) != 'e' || name.charAt(2) != 't' || mNode.getParameters().length != 0 || mNode.isVoidMethod()) break;
                    return BeanUtils.decapitalize(name.substring(3));
                }
                case 's': {
                    if (nameLength <= 3 || name.charAt(1) != 'e' || name.charAt(2) != 't' || mNode.getParameters().length != 1) break;
                    return BeanUtils.decapitalize(name.substring(3));
                }
                case 'i': {
                    if (name.charAt(1) != 's' || mNode.getParameters().length != 0 || !ClassHelper.isPrimitiveBoolean(mNode.getReturnType())) break;
                    return BeanUtils.decapitalize(name.substring(2));
                }
            }
        }
        return null;
    }

    public static BlockStatement getCodeAsBlock(MethodNode mNode) {
        BlockStatement block;
        Statement code = mNode.getCode();
        if (code == null) {
            block = new BlockStatement();
        } else if (!(code instanceof BlockStatement)) {
            block = new BlockStatement();
            block.addStatement(code);
        } else {
            block = (BlockStatement)code;
        }
        return block;
    }

    public static boolean isGetterCandidate(MethodNode mNode) {
        Parameter[] parameters = mNode.getParameters();
        return (parameters == null || parameters.length == 0) && mNode.isPublic() && !mNode.isStatic() && !mNode.isAbstract() && !mNode.isVoidMethod();
    }

    public static List<MethodNode> withDefaultArgumentMethods(List<? extends MethodNode> methods) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>(methods.size());
        for (MethodNode methodNode : methods) {
            result.add(methodNode);
            if (!methodNode.hasDefaultValue()) continue;
            Parameter[] parameters = methodNode.getParameters();
            long n = Arrays.stream(parameters).filter(Parameter::hasInitialExpression).count();
            int i = 1;
            while ((long)i <= n) {
                Parameter[] newParams = new Parameter[parameters.length - i];
                int j = 1;
                int index = 0;
                for (Parameter parameter : parameters) {
                    if ((long)j <= n - (long)i || !parameter.hasInitialExpression()) {
                        newParams[index++] = parameter;
                    }
                    if (!parameter.hasInitialExpression()) continue;
                    ++j;
                }
                MethodNode stub = methodNode.isConstructor() ? new ConstructorNode(methodNode.getModifiers(), newParams, methodNode.getExceptions(), EmptyStatement.INSTANCE) : new MethodNode(methodNode.getName(), methodNode.getModifiers() & 0xFFFFFBFF, methodNode.getReturnType(), newParams, methodNode.getExceptions(), EmptyStatement.INSTANCE);
                stub.setDeclaringClass(methodNode.getDeclaringClass());
                stub.setGenericsTypes(methodNode.getGenericsTypes());
                stub.setSynthetic(true);
                result.add(stub);
                ++i;
            }
        }
        return result;
    }
}

