/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.marshaller;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.partition.replicator.marshaller.PartitionCommandsMarshaller;
import org.apache.ignite.internal.partition.replicator.network.command.CatalogVersionAware;
import org.apache.ignite.internal.raft.util.OptimizedMarshaller;
import org.apache.ignite.internal.replicator.command.SafeTimePropagatingCommand;

public class PartitionCommandsMarshallerImpl
extends OptimizedMarshaller
implements PartitionCommandsMarshaller {
    public PartitionCommandsMarshallerImpl(MessageSerializationRegistry serializationRegistry, OptimizedMarshaller.ByteBuffersPool cache) {
        super(serializationRegistry, cache);
    }

    public void patch(ByteBuffer raw, HybridTimestamp safeTs) {
        raw = raw.order() == ORDER ? raw : raw.duplicate().order(ORDER);
        raw.putLong(4, safeTs.longValue());
    }

    protected void beforeWriteMessage(Object o, ByteBuffer buffer) {
        int requiredCatalogVersion = o instanceof CatalogVersionAware ? ((CatalogVersionAware)o).requiredCatalogVersion() : -1;
        this.stream.setBuffer(buffer);
        this.stream.writeFixedInt(requiredCatalogVersion);
        this.stream.writeFixedLong(0L);
    }

    public <T> T unmarshall(ByteBuffer raw) {
        raw = raw.duplicate().order(ORDER);
        int requiredCatalogVersion = this.readRequiredCatalogVersion(raw);
        long safeTs = this.readSafeTimestamp(raw);
        Object res = super.unmarshall(raw);
        if (res instanceof CatalogVersionAware) {
            ((CatalogVersionAware)res).requiredCatalogVersion(requiredCatalogVersion);
        }
        if (res instanceof SafeTimePropagatingCommand && safeTs != 0L) {
            ((SafeTimePropagatingCommand)res).safeTime(HybridTimestamp.hybridTimestamp((long)safeTs));
        }
        return (T)res;
    }

    @Override
    public int readRequiredCatalogVersion(ByteBuffer raw) {
        return raw.getInt();
    }

    @Override
    public long readSafeTimestamp(ByteBuffer raw) {
        return raw.getLong();
    }
}

