/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMetaBuilder;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.jetbrains.annotations.Nullable;

public class SnapshotMetaUtils {
    public static PartitionSnapshotMeta snapshotMetaAt(long logIndex, long term, RaftGroupConfiguration config, int requiredCatalogVersion, Map<Integer, UUID> nextRowIdToBuildByIndexId, long leaseStartTime, @Nullable UUID primaryReplicaNodeId, @Nullable String primaryReplicaNodeName) {
        PartitionSnapshotMetaBuilder metaBuilder = new PartitionReplicationMessagesFactory().partitionSnapshotMeta().lastIncludedIndex(logIndex).lastIncludedTerm(term).peersList((Collection)config.peers()).learnersList((Collection)config.learners()).requiredCatalogVersion(requiredCatalogVersion).nextRowIdToBuildByIndexId(nextRowIdToBuildByIndexId).leaseStartTime(leaseStartTime).primaryReplicaNodeId(primaryReplicaNodeId).primaryReplicaNodeName(primaryReplicaNodeName);
        if (!config.isStable()) {
            metaBuilder.oldPeersList((Collection)config.oldPeers()).oldLearnersList((Collection)config.oldLearners());
        }
        return metaBuilder.build();
    }

    public static Map<Integer, UUID> collectNextRowIdToBuildIndexes(CatalogService catalogService, PartitionAccess partitionAccess, int catalogVersion) {
        HashMap<Integer, UUID> nextRowIdToBuildByIndexId = new HashMap<Integer, UUID>();
        for (CatalogIndexDescriptor index : catalogService.indexes(catalogVersion, partitionAccess.partitionKey().tableId())) {
            RowId nextRowIdToBuild;
            if (index.status() != CatalogIndexStatus.BUILDING || (nextRowIdToBuild = partitionAccess.getNextRowIdToBuildIndex(index.id())) == null) continue;
            nextRowIdToBuildByIndexId.put(index.id(), nextRowIdToBuild.uuid());
        }
        return nextRowIdToBuildByIndexId;
    }
}

