/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.errors;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.security.errors.ErrorResponse;
import io.micronaut.security.errors.OauthErrorResponseException;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;

@Requires(classes={OauthErrorResponseException.class})
@Produces
@Singleton
public class OauthErrorResponseExceptionHandler
implements ExceptionHandler<OauthErrorResponseException, MutableHttpResponse<?>> {
    public MutableHttpResponse<?> handle(HttpRequest request, OauthErrorResponseException exception) {
        return HttpResponse.badRequest(this.responseBody(exception));
    }

    protected Map<String, Object> responseBody(ErrorResponse errorResponse) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("error", errorResponse.getError().toString());
        if (errorResponse.getErrorDescription() != null) {
            m.put("error_description", errorResponse.getErrorDescription());
        }
        if (errorResponse.getErrorUri() != null) {
            m.put("error_uri", errorResponse.getErrorUri());
        }
        return m;
    }
}

