/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.sql;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.client.handler.ClientHandlerMetricSource;
import org.apache.ignite.client.handler.ClientResource;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCommon;
import org.apache.ignite.client.handler.requests.sql.ClientSqlProperties;
import org.apache.ignite.client.handler.requests.sql.ClientSqlResultSet;
import org.apache.ignite.client.handler.requests.table.ClientTableCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite.internal.sql.api.AsyncResultSetImpl;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.QueryProperty;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.apache.ignite.internal.sql.engine.property.SqlPropertiesHelper;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientSqlExecuteRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, QueryProcessor sql, ClientResourceRegistry resources, ClientHandlerMetricSource metrics) {
        InternalTransaction tx = ClientTableCommon.readTx(in, out, resources);
        ClientSqlProperties props = new ClientSqlProperties(in);
        String statement = in.unpackString();
        Object[] arguments = in.unpackObjectArrayFromBinaryTuple();
        if (arguments == null) {
            arguments = ArrayUtils.OBJECT_EMPTY_ARRAY;
        }
        HybridTimestamp clientTs = HybridTimestamp.nullableHybridTimestamp((long)in.unpackLong());
        HybridTimestampTracker tsUpdater = HybridTimestampTracker.clientTracker((HybridTimestamp)clientTs, arg_0 -> ((ClientMessagePacker)out).meta(arg_0));
        return ClientSqlExecuteRequest.executeAsync((Transaction)tx, sql, tsUpdater, statement, props.pageSize(), props.toSqlProps(), arguments).thenCompose(asyncResultSet -> ClientSqlExecuteRequest.writeResultSetAsync(out, resources, asyncResultSet, metrics));
    }

    private static CompletionStage<Void> writeResultSetAsync(ClientMessagePacker out, ClientResourceRegistry resources, AsyncResultSet asyncResultSet, ClientHandlerMetricSource metrics) {
        boolean hasResource;
        boolean bl = hasResource = asyncResultSet.hasRowSet() && asyncResultSet.hasMorePages();
        if (hasResource) {
            try {
                metrics.cursorsActiveIncrement();
                ClientSqlResultSet clientResultSet = new ClientSqlResultSet((AsyncResultSet<SqlRow>)asyncResultSet, metrics);
                ClientResource resource = new ClientResource(clientResultSet, clientResultSet::closeAsync);
                out.packLong(resources.put(resource));
            }
            catch (IgniteInternalCheckedException e) {
                return asyncResultSet.closeAsync().thenRun(() -> {
                    throw new IgniteInternalException(e.getMessage(), (Throwable)e);
                });
            }
        } else {
            out.packNil();
        }
        out.packBoolean(asyncResultSet.hasRowSet());
        out.packBoolean(asyncResultSet.hasMorePages());
        out.packBoolean(asyncResultSet.wasApplied());
        out.packLong(asyncResultSet.affectedRows());
        ClientSqlExecuteRequest.packMeta(out, asyncResultSet.metadata());
        if (asyncResultSet.hasRowSet()) {
            ClientSqlCommon.packCurrentPage(out, (AsyncResultSet<SqlRow>)asyncResultSet);
            return hasResource ? CompletableFutures.nullCompletedFuture() : asyncResultSet.closeAsync();
        }
        return asyncResultSet.closeAsync();
    }

    private static void packMeta(ClientMessagePacker out, @Nullable ResultSetMetadata meta) {
        if (meta == null || meta.columns() == null) {
            out.packInt(0);
            return;
        }
        ClientSqlCommon.packColumns(out, meta.columns());
    }

    private static CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, QueryProcessor qryProc, HybridTimestampTracker timestampTracker, String query, int pageSize, SqlProperties props, Object ... arguments) {
        try {
            SqlProperties properties = SqlPropertiesHelper.builderFromProperties((SqlProperties)props).set(QueryProperty.ALLOWED_QUERY_TYPES, (Object)SqlQueryType.SINGLE_STMT_TYPES).build();
            CompletionStage fut = qryProc.queryAsync(properties, timestampTracker, (InternalTransaction)transaction, null, query, arguments).thenCompose(cur -> cur.requestNextAsync(pageSize).thenApply(batchRes -> new AsyncResultSetImpl(cur, batchRes, pageSize)));
            return ((CompletableFuture)fut).exceptionally(th -> {
                Throwable cause = ExceptionUtils.unwrapCause((Throwable)th);
                throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException((Throwable)cause));
            });
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(SqlExceptionMapperUtil.mapToPublicSqlException((Throwable)e));
        }
    }
}

