/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;
import org.apache.ignite.internal.sql.engine.InternalSqlRowSingleLong;
import org.apache.ignite.internal.sql.engine.QueryPrefetchCallback;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.ExecutablePlan;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlRowProvider;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.internal.util.AsyncCursor;
import org.apache.ignite.internal.util.AsyncWrapper;
import org.apache.ignite.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class KeyValueModifyPlan
implements ExplainablePlan,
ExecutablePlan {
    private final PlanId id;
    private final int catalogVersion;
    private final IgniteKeyValueModify modifyNode;
    private final ResultSetMetadata meta;
    private final ParameterMetadata parameterMetadata;
    private volatile InsertExecution<?> operation;

    KeyValueModifyPlan(PlanId id, int catalogVersion, IgniteKeyValueModify modifyNode, ResultSetMetadata meta, ParameterMetadata parameterMetadata) {
        this.id = id;
        this.catalogVersion = catalogVersion;
        this.modifyNode = modifyNode;
        this.meta = meta;
        this.parameterMetadata = parameterMetadata;
    }

    @Override
    public PlanId id() {
        return this.id;
    }

    @Override
    public SqlQueryType type() {
        return SqlQueryType.DML;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    public ParameterMetadata parameterMetadata() {
        return this.parameterMetadata;
    }

    private IgniteTable table() {
        IgniteTable table = (IgniteTable)this.modifyNode.getTable().unwrap(IgniteTable.class);
        assert (table != null) : this.modifyNode.getTable();
        return table;
    }

    @Override
    public String explain() {
        IgniteRel clonedRoot = Cloner.clone(this.modifyNode, Commons.cluster());
        return RelOptUtil.toString((RelNode)clonedRoot, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
    }

    public IgniteKeyValueModify modifyNode() {
        return this.modifyNode;
    }

    private <RowT> InsertExecution<RowT> operation(ExecutionContext<RowT> ctx, ExecutableTableRegistry tableRegistry) {
        InsertExecution<RowT> operation = (InsertExecution<RowT>)Commons.cast(this.operation);
        if (operation != null) {
            return operation;
        }
        IgniteTable sqlTable = this.table();
        ExecutableTable execTable = tableRegistry.getTable(this.catalogVersion, sqlTable.id());
        List<RexNode> expressions = this.modifyNode.expressions();
        SqlRowProvider<RowT> rowSupplier = ctx.expressionFactory().rowSource(expressions);
        UpdatableTable table = execTable.updatableTable();
        operation = new InsertExecution<RowT>(table, rowSupplier);
        this.operation = operation;
        return operation;
    }

    @Override
    public <RowT> AsyncCursor<InternalSqlRow> execute(ExecutionContext<RowT> ctx, InternalTransaction tx, ExecutableTableRegistry tableRegistry, @Nullable QueryPrefetchCallback firstPageReadyCallback) {
        InsertExecution<RowT> operation = this.operation(ctx, tableRegistry);
        CompletableFuture<Iterator<InternalSqlRow>> result = operation.perform(ctx, tx);
        if (firstPageReadyCallback != null) {
            result.whenComplete((res, err) -> firstPageReadyCallback.onPrefetchComplete((Throwable)err));
        }
        ctx.scheduleTimeout(result);
        return new AsyncWrapper(result, Runnable::run);
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    private static class InsertExecution<RowT> {
        private final UpdatableTable table;
        private final SqlRowProvider<RowT> rowSupplier;

        private InsertExecution(UpdatableTable table, SqlRowProvider<RowT> rowSupplier) {
            this.table = table;
            this.rowSupplier = rowSupplier;
        }

        CompletableFuture<Iterator<InternalSqlRow>> perform(ExecutionContext<RowT> ctx, InternalTransaction tx) {
            return this.table.insert(tx, ctx, this.rowSupplier.get(ctx)).thenApply(none -> List.of(new InternalSqlRowSingleLong(1L)).iterator());
        }
    }
}

