/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.event;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.security.authentication.AuthenticationUtils;
import org.apache.ignite.internal.security.authentication.basic.BasicUserView;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationProviderView;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationView;
import org.apache.ignite.internal.security.authentication.event.AuthenticationEventParameters;
import org.apache.ignite.internal.security.authentication.event.UserEventParameters;

public class UserEventFactory
implements ConfigurationNamedListListener<BasicUserView> {
    private final Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier;

    public UserEventFactory(Function<AuthenticationEventParameters, CompletableFuture<Void>> notifier) {
        this.notifier = notifier;
    }

    public CompletableFuture<?> onRename(ConfigurationNotificationEvent<BasicUserView> ctx) {
        AuthenticationView authenticationView = (AuthenticationView)ctx.oldValue(AuthenticationView.class);
        String basicProviderName = AuthenticationUtils.findBasicProviderName((NamedListView<? extends AuthenticationProviderView>)authenticationView.providers());
        return this.notifier.apply((AuthenticationEventParameters)UserEventParameters.removed((String)basicProviderName, (String)((BasicUserView)ctx.oldValue()).username()));
    }

    public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<BasicUserView> ctx) {
        AuthenticationView authenticationView = (AuthenticationView)ctx.oldValue(AuthenticationView.class);
        String basicProviderName = AuthenticationUtils.findBasicProviderName((NamedListView<? extends AuthenticationProviderView>)authenticationView.providers());
        return this.notifier.apply((AuthenticationEventParameters)UserEventParameters.removed((String)basicProviderName, (String)((BasicUserView)ctx.oldValue()).username()));
    }

    public CompletableFuture<?> onUpdate(ConfigurationNotificationEvent<BasicUserView> ctx) {
        AuthenticationView authenticationView = (AuthenticationView)ctx.oldValue(AuthenticationView.class);
        String basicProviderName = AuthenticationUtils.findBasicProviderName((NamedListView<? extends AuthenticationProviderView>)authenticationView.providers());
        return this.notifier.apply((AuthenticationEventParameters)UserEventParameters.updated((String)basicProviderName, (String)((BasicUserView)ctx.oldValue()).username()));
    }
}

