/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataRequestBuilder;

class SnapshotTxDataRequestDeserializer
implements MessageDeserializer<SnapshotTxDataRequest> {
    private final SnapshotTxDataRequestBuilder msg;

    SnapshotTxDataRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotTxDataRequest();
    }

    public Class<SnapshotTxDataRequest> klass() {
        return SnapshotTxDataRequest.class;
    }

    public SnapshotTxDataRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.id(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("maxTransactionsInBatch");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.maxTransactionsInBatch(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotTxDataRequest.class);
    }
}

