/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

class LocalStateStorage {
    private static final ByteArray CMG_STATE_VAULT_KEY = ByteArray.fromString((String)"cmg_state");
    private final VaultManager vault;

    LocalStateStorage(VaultManager vault) {
        this.vault = vault;
    }

    @Nullable
    LocalState getLocalState() {
        VaultEntry entry = this.vault.get(CMG_STATE_VAULT_KEY);
        if (entry == null) {
            return null;
        }
        return (LocalState)VersionedSerialization.fromBytes((byte[])entry.value(), (VersionedSerializer)LocalStateSerializer.INSTANCE);
    }

    void saveLocalState(LocalState state) {
        this.vault.put(CMG_STATE_VAULT_KEY, VersionedSerialization.toBytes((Object)state, (VersionedSerializer)LocalStateSerializer.INSTANCE));
    }

    void clear() {
        this.vault.remove(CMG_STATE_VAULT_KEY);
    }

    private static class LocalStateSerializer
    extends VersionedSerializer<LocalState> {
        private static final CmgMessagesFactory CMG_MESSAGES_FACTORY = new CmgMessagesFactory();
        private static final LocalStateSerializer INSTANCE = new LocalStateSerializer();

        private LocalStateSerializer() {
        }

        protected void writeExternalData(LocalState state, IgniteDataOutput out) throws IOException {
            out.writeVarInt((long)state.cmgNodeNames().size());
            for (String cmgNodeName : state.cmgNodeNames()) {
                out.writeUTF(cmgNodeName);
            }
            out.writeUTF(state.clusterTag().clusterName());
            out.writeUuid(state.clusterTag().clusterId());
        }

        protected LocalState readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
            int cmgNodesCount = in.readVarIntAsInt();
            HashSet<String> cmgNodeNames = new HashSet<String>(cmgNodesCount);
            for (int i = 0; i < cmgNodesCount; ++i) {
                cmgNodeNames.add(in.readUTF());
            }
            ClusterTag clusterTag = ClusterTag.clusterTag(CMG_MESSAGES_FACTORY, in.readUTF(), in.readUuid());
            return new LocalState(cmgNodeNames, clusterTag);
        }
    }

    static class LocalState {
        private final Set<String> cmgNodeNames;
        private final ClusterTag clusterTag;

        LocalState(Set<String> cmgNodeNames, ClusterTag clusterTag) {
            this.cmgNodeNames = Set.copyOf(cmgNodeNames);
            this.clusterTag = clusterTag;
        }

        Set<String> cmgNodeNames() {
            return this.cmgNodeNames;
        }

        ClusterTag clusterTag() {
            return this.clusterTag;
        }
    }
}

