/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.eventlog.api.Event;
import org.apache.ignite.internal.eventlog.api.IgniteEventType;
import org.apache.ignite.internal.eventlog.event.EventUser;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.fsm.QueryInfo;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;

public class QueryEventsFactory {
    private final String localNode;

    public QueryEventsFactory(String localNode) {
        this.localNode = localNode;
    }

    public Event makeStartEvent(QueryInfo queryInfo, EventUser user) {
        LinkedHashMap fields = IgniteUtils.newLinkedHashMap((int)7);
        this.fillCommonFields(fields, queryInfo);
        return IgniteEventType.QUERY_STARTED.builder().user(user).timestamp(queryInfo.startTime().toEpochMilli()).fields((Map)fields).build();
    }

    public Event makeFinishEvent(QueryInfo queryInfo, EventUser user, long finishTime) {
        LinkedHashMap fields = IgniteUtils.newLinkedHashMap((int)10);
        this.fillCommonFields(fields, queryInfo);
        fields.put("startTime", queryInfo.startTime().toEpochMilli());
        SqlQueryType queryType = queryInfo.queryType();
        fields.put("type", queryType == null ? null : queryType.name());
        Throwable error = queryInfo.error();
        fields.put("errorMessage", error == null ? null : ExceptionUtils.unwrapCause((Throwable)error).getMessage());
        return IgniteEventType.QUERY_FINISHED.builder().user(user).timestamp(finishTime).fields((Map)fields).build();
    }

    private void fillCommonFields(Map<String, Object> fields, QueryInfo queryInfo) {
        fields.put("initiatorNode", this.localNode);
        fields.put("id", queryInfo.id());
        fields.put("schema", queryInfo.schema());
        fields.put("sql", queryInfo.sql());
        fields.put("parentId", queryInfo.parentId());
        fields.put("statementNum", queryInfo.statementNum());
        fields.put("transactionId", queryInfo.transactionId());
    }

    static class FieldNames {
        static final String INITIATOR = "initiatorNode";
        static final String ID = "id";
        static final String SCHEMA = "schema";
        static final String SQL = "sql";
        static final String PARENT_ID = "parentId";
        static final String STATEMENT_NUMBER = "statementNum";
        static final String TX_ID = "transactionId";
        static final String START_TIME = "startTime";
        static final String TYPE = "type";
        static final String ERROR = "errorMessage";

        FieldNames() {
        }
    }
}

