/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.UnresolvableConsistentIdException;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.message.CancelOperationRequest;
import org.apache.ignite.internal.sql.engine.message.ExecutionContextAwareMessage;
import org.apache.ignite.internal.sql.engine.message.MessageListener;
import org.apache.ignite.internal.sql.engine.message.MessageService;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessageGroup;
import org.apache.ignite.internal.sql.engine.message.UnknownNodeException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.Nullable;

public class MessageServiceImpl
implements MessageService {
    private final MessagingService messagingSrvc;
    private final InternalClusterNode localNode;
    private final QueryTaskExecutor taskExecutor;
    private final IgniteSpinBusyLock busyLock;
    private final ClockService clockService;
    private volatile Int2ObjectMap<MessageListener> lsnrs;

    public MessageServiceImpl(InternalClusterNode localNode, MessagingService messagingSrvc, QueryTaskExecutor taskExecutor, IgniteSpinBusyLock busyLock, ClockService clockService) {
        this.localNode = localNode;
        this.messagingSrvc = messagingSrvc;
        this.taskExecutor = taskExecutor;
        this.busyLock = busyLock;
        this.clockService = clockService;
    }

    @Override
    public void start() {
        this.messagingSrvc.addMessageHandler(SqlQueryMessageGroup.class, this::onMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> send(String nodeName, NetworkMessage msg) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            if (this.localNode.name().equals(nodeName)) {
                this.onMessage(this.localNode, msg);
                CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
                return completableFuture;
            }
            CompletionStage completionStage = this.messagingSrvc.send(nodeName, ChannelType.DEFAULT, msg).exceptionally(ex -> {
                if (ex instanceof UnresolvableConsistentIdException) {
                    ex = new UnknownNodeException(nodeName);
                }
                ExceptionUtils.sneakyThrow((Throwable)ex);
                throw new AssertionError((Object)"Should not get here");
            });
            return completionStage;
        }
        catch (Exception ex2) {
            CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(ex2);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void register(MessageListener lsnr, short type) {
        if (this.lsnrs == null) {
            this.lsnrs = new Int2ObjectOpenHashMap();
        }
        MessageListener old = (MessageListener)this.lsnrs.put((int)type, (Object)lsnr);
        assert (old == null) : old;
    }

    private void onMessage(InternalClusterNode sender, NetworkMessage msg) {
        if (msg instanceof CancelOperationRequest) {
            return;
        }
        if (msg instanceof ExecutionContextAwareMessage) {
            ExecutionContextAwareMessage msg0 = (ExecutionContextAwareMessage)msg;
            this.taskExecutor.execute(msg0.queryId(), msg0.fragmentId(), () -> this.onMessageInternal(sender, msg));
        } else {
            this.taskExecutor.execute(() -> this.onMessageInternal(sender, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessage(NetworkMessage msg, InternalClusterNode sender, @Nullable Long correlationId) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            assert (msg.groupType() == 4) : "unexpected message group grpType=" + msg.groupType();
            if (msg instanceof TimestampAware) {
                this.clockService.updateClock(((TimestampAware)msg).timestamp());
            }
            this.onMessage(sender, msg);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageInternal(InternalClusterNode sender, NetworkMessage msg) {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            MessageListener lsnr = Objects.requireNonNull((MessageListener)this.lsnrs.get((int)msg.messageType()), "there is no listener for msgType=" + msg.messageType());
            lsnr.onMessage(sender, msg);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void stop() {
        if (this.lsnrs != null) {
            this.lsnrs.clear();
        }
    }
}

