/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.BufferedFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.WriteOnlyZipFileIO;
import org.apache.ignite.internal.util.typedef.internal.A;

public class WriteOnlyZipFileIOFactory
extends BufferedFileIOFactory {
    private static final long serialVersionUID = 0L;

    public WriteOnlyZipFileIOFactory(FileIOFactory factory) {
        super(factory);
    }

    @Override
    public WriteOnlyZipFileIO create(File file, OpenOption ... modes) throws IOException {
        A.ensure(file.getName().endsWith(".zip"), "File name should end with .zip");
        String entryName = file.getName().substring(0, file.getName().length() - ".zip".length());
        return new WriteOnlyZipFileIO(this.factory.create(file, modes), entryName);
    }
}

