/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import java.util.Objects;

class SharedSubscriptionUtils {
    SharedSubscriptionUtils() {
    }

    protected static String extractShareName(String sharedTopicFilter) {
        int afterShare = "$share/".length();
        int endOfShareName = sharedTopicFilter.indexOf(47, afterShare);
        return sharedTopicFilter.substring(afterShare, endOfShareName);
    }

    protected static String extractFilterFromShared(String fullSharedTopicFilter) {
        int afterShare = "$share/".length();
        int endOfShareName = fullSharedTopicFilter.indexOf(47, afterShare);
        return fullSharedTopicFilter.substring(endOfShareName + 1);
    }

    protected static boolean isSharedSubscription(String topicFilter) {
        Objects.requireNonNull(topicFilter, "topicFilter can't be null");
        return topicFilter.startsWith("$share/");
    }

    protected static boolean validateShareName(String shareName) {
        Objects.requireNonNull(shareName);
        return shareName.length() > 0 && !shareName.contains("+") && !shareName.contains("#");
    }
}

