/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.plugin;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class CreatePipePluginPlan
extends ConfigPhysicalPlan {
    private PipePluginMeta pipePluginMeta;
    private Binary jarFile;

    public CreatePipePluginPlan() {
        super(ConfigPhysicalPlanType.CreatePipePlugin);
    }

    public CreatePipePluginPlan(PipePluginMeta pipePluginMeta, Binary jarFile) {
        super(ConfigPhysicalPlanType.CreatePipePlugin);
        this.pipePluginMeta = pipePluginMeta;
        this.jarFile = jarFile;
    }

    public PipePluginMeta getPipePluginMeta() {
        return this.pipePluginMeta;
    }

    public Binary getJarFile() {
        return this.jarFile;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        this.pipePluginMeta.serialize(stream);
        if (this.jarFile == null) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
            ReadWriteIOUtils.write((Binary)this.jarFile, (OutputStream)stream);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.pipePluginMeta = PipePluginMeta.deserialize((ByteBuffer)buffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)buffer)) {
            return;
        }
        this.jarFile = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
    }
}

