/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;

public abstract class UDTFContinuouslySatisfy
implements UDTF {
    protected long min;
    protected long max;
    protected TSDataType dataType;
    protected long satisfyValueCount;
    protected long satisfyValueLastTime;
    protected long satisfyValueStartTime;
    protected Pair<Long, Long> interval;

    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE, Type.BOOLEAN}).validate(args -> (Long)args[1] >= (Long)args[0], "max can not be smaller than min.", new Object[]{validator.getParameters().getLongOrDefault("min", this.getDefaultMin()), validator.getParameters().getLongOrDefault("max", this.getDefaultMax())}).validate(min -> (Long)min >= this.getDefaultMin(), "min can not be smaller than " + this.getDefaultMin() + ".", (Object)validator.getParameters().getLongOrDefault("min", this.getDefaultMin()));
    }

    protected abstract long getDefaultMin();

    protected abstract long getDefaultMax();

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException, UDFInputSeriesDataTypeNotValidException {
        this.satisfyValueCount = 0L;
        this.satisfyValueStartTime = 0L;
        this.satisfyValueLastTime = -1L;
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(0));
        this.min = parameters.getLongOrDefault("min", this.getDefaultMin());
        this.max = parameters.getLongOrDefault("max", this.getDefaultMax());
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.INT64);
    }

    public void transform(Row row, PointCollector collector) throws IOException, UDFInputSeriesDataTypeNotValidException {
        boolean needAddNewRecord;
        switch (this.dataType) {
            case INT32: {
                needAddNewRecord = this.transformInt(row.getTime(), row.getInt(0));
                break;
            }
            case INT64: {
                needAddNewRecord = this.transformLong(row.getTime(), row.getLong(0));
                break;
            }
            case FLOAT: {
                needAddNewRecord = this.transformFloat(row.getTime(), row.getFloat(0));
                break;
            }
            case DOUBLE: {
                needAddNewRecord = this.transformDouble(row.getTime(), row.getDouble(0));
                break;
            }
            case BOOLEAN: {
                needAddNewRecord = this.transformBoolean(row.getTime(), row.getBoolean(0));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
        if (needAddNewRecord) {
            collector.putLong(((Long)this.interval.left).longValue(), ((Long)this.interval.right).longValue());
        }
    }

    protected boolean transformDouble(long time, double value) {
        if (this.satisfyDouble(value)) {
            if (this.satisfyValueCount == 0L) {
                this.satisfyValueStartTime = time;
            }
            ++this.satisfyValueCount;
            this.satisfyValueLastTime = time;
        } else {
            if (this.getRecord() >= this.min && this.getRecord() <= this.max && this.satisfyValueCount > 0L) {
                this.interval = new Pair((Object)this.satisfyValueStartTime, (Object)this.getRecord());
                this.satisfyValueCount = 0L;
                return true;
            }
            this.satisfyValueCount = 0L;
        }
        return false;
    }

    protected boolean transformFloat(long time, float value) {
        if (this.satisfyFloat(value)) {
            if (this.satisfyValueCount == 0L) {
                this.satisfyValueStartTime = time;
            }
            ++this.satisfyValueCount;
            this.satisfyValueLastTime = time;
        } else {
            if (this.getRecord() >= this.min && this.getRecord() <= this.max && this.satisfyValueCount > 0L) {
                this.interval = new Pair((Object)this.satisfyValueStartTime, (Object)this.getRecord());
                this.satisfyValueCount = 0L;
                return true;
            }
            this.satisfyValueCount = 0L;
        }
        return false;
    }

    protected boolean transformLong(long time, long value) {
        if (this.satisfyLong(value)) {
            if (this.satisfyValueCount == 0L) {
                this.satisfyValueStartTime = time;
            }
            ++this.satisfyValueCount;
            this.satisfyValueLastTime = time;
        } else {
            if (this.getRecord() >= this.min && this.getRecord() <= this.max && this.satisfyValueCount > 0L) {
                this.interval = new Pair((Object)this.satisfyValueStartTime, (Object)this.getRecord());
                this.satisfyValueCount = 0L;
                return true;
            }
            this.satisfyValueCount = 0L;
        }
        return false;
    }

    protected boolean transformInt(long time, int value) {
        if (this.satisfyInt(value)) {
            if (this.satisfyValueCount == 0L) {
                this.satisfyValueStartTime = time;
            }
            ++this.satisfyValueCount;
            this.satisfyValueLastTime = time;
        } else {
            if (this.getRecord() >= this.min && this.getRecord() <= this.max && this.satisfyValueCount > 0L) {
                this.interval = new Pair((Object)this.satisfyValueStartTime, (Object)this.getRecord());
                this.satisfyValueCount = 0L;
                return true;
            }
            this.satisfyValueCount = 0L;
        }
        return false;
    }

    protected boolean transformBoolean(long time, boolean value) {
        if (this.satisfyBoolean(value)) {
            if (this.satisfyValueCount == 0L) {
                this.satisfyValueStartTime = time;
            }
            ++this.satisfyValueCount;
            this.satisfyValueLastTime = time;
        } else {
            if (this.getRecord() >= this.min && this.getRecord() <= this.max && this.satisfyValueCount > 0L) {
                this.interval = new Pair((Object)this.satisfyValueStartTime, (Object)this.getRecord());
                this.satisfyValueCount = 0L;
                return true;
            }
            this.satisfyValueCount = 0L;
        }
        return false;
    }

    protected abstract Long getRecord();

    public void terminate(PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        switch (this.dataType) {
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (this.satisfyValueCount <= 0L || this.getRecord() < this.min || this.getRecord() > this.max) break;
                collector.putLong(this.satisfyValueStartTime, this.getRecord().longValue());
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE});
            }
        }
    }

    protected abstract boolean satisfyInt(int var1);

    protected abstract boolean satisfyLong(long var1);

    protected abstract boolean satisfyFloat(float var1);

    protected abstract boolean satisfyDouble(double var1);

    protected abstract boolean satisfyBoolean(Boolean var1);
}

