/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.DiscoveryConfiguration;

public class MdnsDiscoveryConfiguration
extends DiscoveryConfiguration
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12891");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12893");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12901");
    private final String mdnsServerName;
    private final String[] serverCapabilities;

    public MdnsDiscoveryConfiguration(String mdnsServerName, String[] serverCapabilities) {
        this.mdnsServerName = mdnsServerName;
        this.serverCapabilities = serverCapabilities;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getMdnsServerName() {
        return this.mdnsServerName;
    }

    public String[] getServerCapabilities() {
        return this.serverCapabilities;
    }

    protected MdnsDiscoveryConfiguration(MdnsDiscoveryConfigurationBuilder<?, ?> b) {
        super((DiscoveryConfiguration.DiscoveryConfigurationBuilder<?, ?>)b);
        this.mdnsServerName = ((MdnsDiscoveryConfigurationBuilder)b).mdnsServerName;
        this.serverCapabilities = ((MdnsDiscoveryConfigurationBuilder)b).serverCapabilities;
    }

    public static MdnsDiscoveryConfigurationBuilder<?, ?> builder() {
        return new MdnsDiscoveryConfigurationBuilderImpl();
    }

    public MdnsDiscoveryConfigurationBuilder<?, ?> toBuilder() {
        return new MdnsDiscoveryConfigurationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MdnsDiscoveryConfiguration)) {
            return false;
        }
        MdnsDiscoveryConfiguration other = (MdnsDiscoveryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$mdnsServerName = this.getMdnsServerName();
        String other$mdnsServerName = other.getMdnsServerName();
        if (this$mdnsServerName == null ? other$mdnsServerName != null : !this$mdnsServerName.equals(other$mdnsServerName)) {
            return false;
        }
        return Arrays.deepEquals(this.getServerCapabilities(), other.getServerCapabilities());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MdnsDiscoveryConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $mdnsServerName = this.getMdnsServerName();
        result = result * 59 + ($mdnsServerName == null ? 43 : $mdnsServerName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServerCapabilities());
        return result;
    }

    @Override
    public String toString() {
        return "MdnsDiscoveryConfiguration(mdnsServerName=" + this.getMdnsServerName() + ", serverCapabilities=" + Arrays.deepToString(this.getServerCapabilities()) + ")";
    }

    private static final class MdnsDiscoveryConfigurationBuilderImpl
    extends MdnsDiscoveryConfigurationBuilder<MdnsDiscoveryConfiguration, MdnsDiscoveryConfigurationBuilderImpl> {
        private MdnsDiscoveryConfigurationBuilderImpl() {
        }

        @Override
        protected MdnsDiscoveryConfigurationBuilderImpl self() {
            return this;
        }

        @Override
        public MdnsDiscoveryConfiguration build() {
            return new MdnsDiscoveryConfiguration(this);
        }
    }

    public static abstract class MdnsDiscoveryConfigurationBuilder<C extends MdnsDiscoveryConfiguration, B extends MdnsDiscoveryConfigurationBuilder<C, B>>
    extends DiscoveryConfiguration.DiscoveryConfigurationBuilder<C, B> {
        private String mdnsServerName;
        private String[] serverCapabilities;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MdnsDiscoveryConfigurationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MdnsDiscoveryConfiguration instance, MdnsDiscoveryConfigurationBuilder<?, ?> b) {
            b.mdnsServerName(instance.mdnsServerName);
            b.serverCapabilities(instance.serverCapabilities);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B mdnsServerName(String mdnsServerName) {
            this.mdnsServerName = mdnsServerName;
            return (B)this.self();
        }

        public B serverCapabilities(String[] serverCapabilities) {
            this.serverCapabilities = serverCapabilities;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MdnsDiscoveryConfiguration.MdnsDiscoveryConfigurationBuilder(super=" + super.toString() + ", mdnsServerName=" + this.mdnsServerName + ", serverCapabilities=" + Arrays.deepToString(this.serverCapabilities) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MdnsDiscoveryConfiguration> {
        @Override
        public Class<MdnsDiscoveryConfiguration> getType() {
            return MdnsDiscoveryConfiguration.class;
        }

        @Override
        public MdnsDiscoveryConfiguration decode(SerializationContext context, UaDecoder decoder) {
            String mdnsServerName = decoder.readString("MdnsServerName");
            String[] serverCapabilities = decoder.readStringArray("ServerCapabilities");
            return new MdnsDiscoveryConfiguration(mdnsServerName, serverCapabilities);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MdnsDiscoveryConfiguration value) {
            encoder.writeString("MdnsServerName", value.getMdnsServerName());
            encoder.writeStringArray("ServerCapabilities", value.getServerCapabilities());
        }
    }
}

