/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.structure.BalanceTreeMap;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.partition.DataPartitionPolicyTable;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionBalancer.class);
    private final IManager configManager;
    private final DataPartitionAllocationStrategy dataPartitionAllocationStrategy;
    private final Map<String, DataPartitionPolicyTable> dataPartitionPolicyTableMap;

    public PartitionBalancer(IManager configManager) {
        this.configManager = configManager;
        this.dataPartitionPolicyTableMap = new ConcurrentHashMap<String, DataPartitionPolicyTable>();
        switch (ConfigNodeDescriptor.getInstance().getConf().getDataPartitionAllocationStrategy()) {
            case "INHERIT": {
                this.dataPartitionAllocationStrategy = DataPartitionAllocationStrategy.INHERIT;
                break;
            }
            case "SHUFFLE": {
                this.dataPartitionAllocationStrategy = DataPartitionAllocationStrategy.SHUFFLE;
                break;
            }
            default: {
                LOGGER.warn("Unknown DataPartition allocation strategy {}, using INHERIT strategy by default.", (Object)ConfigNodeDescriptor.getInstance().getConf().getDataPartitionAllocationStrategy());
                this.dataPartitionAllocationStrategy = DataPartitionAllocationStrategy.INHERIT;
            }
        }
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NoAvailableRegionGroupException {
        HashMap<String, SchemaPartitionTable> result = new HashMap<String, SchemaPartitionTable>();
        for (Map.Entry<String, List<TSeriesPartitionSlot>> slotsMapEntry : unassignedSchemaPartitionSlotsMap.entrySet()) {
            String database = slotsMapEntry.getKey();
            List<TSeriesPartitionSlot> unassignedPartitionSlots = slotsMapEntry.getValue();
            BalanceTreeMap counter = new BalanceTreeMap();
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionGroupSlotsCounter(database, TConsensusGroupType.SchemaRegion);
            for (Pair<Long, TConsensusGroupId> pair : regionSlotsCounter) {
                counter.put((Object)((TConsensusGroupId)pair.getRight()), (Comparable)Integer.valueOf(((Long)pair.getLeft()).intValue()));
            }
            HashMap<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
            for (TSeriesPartitionSlot seriesPartitionSlot : unassignedPartitionSlots) {
                TConsensusGroupId consensusGroupId = (TConsensusGroupId)counter.getKeyWithMinValue();
                schemaPartitionMap.put(seriesPartitionSlot, consensusGroupId);
                counter.put((Object)consensusGroupId, (Comparable)Integer.valueOf((Integer)counter.get((Object)consensusGroupId) + 1));
            }
            result.put(database, new SchemaPartitionTable(schemaPartitionMap));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap) throws DatabaseNotExistsException, NoAvailableRegionGroupException {
        TreeMap<String, DataPartitionTable> result = new TreeMap<String, DataPartitionTable>();
        for (Map.Entry<String, Map<TSeriesPartitionSlot, TTimeSlotList>> slotsMapEntry : unassignedDataPartitionSlotsMap.entrySet()) {
            String database = slotsMapEntry.getKey();
            Map<TSeriesPartitionSlot, TTimeSlotList> unassignedPartitionSlotsMap = slotsMapEntry.getValue();
            BalanceTreeMap availableDataRegionGroupCounter = new BalanceTreeMap();
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionGroupSlotsCounter(database, TConsensusGroupType.DataRegion);
            for (Pair<Long, TConsensusGroupId> pair : regionSlotsCounter) {
                availableDataRegionGroupCounter.put((Object)((TConsensusGroupId)pair.getRight()), (Comparable)Integer.valueOf(((Long)pair.getLeft()).intValue()));
            }
            DataPartitionTable dataPartitionTable = new DataPartitionTable();
            if (!this.dataPartitionPolicyTableMap.containsKey(database)) {
                throw new DatabaseNotExistsException(database);
            }
            DataPartitionPolicyTable allotTable = this.dataPartitionPolicyTableMap.get(database);
            try {
                allotTable.acquireLock();
                for (Map.Entry<TSeriesPartitionSlot, TTimeSlotList> seriesPartitionEntry : unassignedPartitionSlotsMap.entrySet()) {
                    SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
                    TSeriesPartitionSlot seriesPartitionSlot = seriesPartitionEntry.getKey();
                    List timePartitionSlots = seriesPartitionEntry.getValue().getTimePartitionSlots();
                    timePartitionSlots.sort(Comparator.comparingLong(TTimePartitionSlot::getStartTime));
                    switch (this.dataPartitionAllocationStrategy) {
                        case INHERIT: {
                            this.inheritAllocationStrategy(database, allotTable, seriesPartitionSlot, timePartitionSlots, (BalanceTreeMap<TConsensusGroupId, Integer>)availableDataRegionGroupCounter, seriesPartitionTable);
                            break;
                        }
                        case SHUFFLE: {
                            this.shuffleAllocationStrategy(database, seriesPartitionSlot, timePartitionSlots, (BalanceTreeMap<TConsensusGroupId, Integer>)availableDataRegionGroupCounter, seriesPartitionTable);
                        }
                    }
                    dataPartitionTable.getDataPartitionMap().put(seriesPartitionEntry.getKey(), seriesPartitionTable);
                }
            }
            finally {
                allotTable.releaseLock();
            }
            result.put(database, dataPartitionTable);
        }
        return result;
    }

    private void inheritAllocationStrategy(String database, DataPartitionPolicyTable allotTable, TSeriesPartitionSlot seriesPartitionSlot, List<TTimePartitionSlot> timePartitionSlots, BalanceTreeMap<TConsensusGroupId, Integer> availableDataRegionGroupCounter, SeriesPartitionTable seriesPartitionTable) {
        for (TTimePartitionSlot timePartitionSlot : timePartitionSlots) {
            TConsensusGroupId successor = this.getPartitionManager().getSuccessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
            if (successor != null && availableDataRegionGroupCounter.containsKey((Object)successor)) {
                seriesPartitionTable.putDataPartition(timePartitionSlot, successor);
                availableDataRegionGroupCounter.put((Object)successor, (Comparable)Integer.valueOf((Integer)availableDataRegionGroupCounter.get((Object)successor) + 1));
                continue;
            }
            TConsensusGroupId allotGroupId = allotTable.getRegionGroupIdOrActivateIfNecessary(seriesPartitionSlot);
            if (availableDataRegionGroupCounter.containsKey((Object)allotGroupId)) {
                seriesPartitionTable.putDataPartition(timePartitionSlot, allotGroupId);
                availableDataRegionGroupCounter.put((Object)allotGroupId, (Comparable)Integer.valueOf((Integer)availableDataRegionGroupCounter.get((Object)allotGroupId) + 1));
                continue;
            }
            TConsensusGroupId predecessor = this.getPartitionManager().getPredecessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
            if (predecessor != null && availableDataRegionGroupCounter.containsKey((Object)predecessor)) {
                seriesPartitionTable.putDataPartition(timePartitionSlot, predecessor);
                availableDataRegionGroupCounter.put((Object)predecessor, (Comparable)Integer.valueOf((Integer)availableDataRegionGroupCounter.get((Object)predecessor) + 1));
                continue;
            }
            TConsensusGroupId greedyGroupId = (TConsensusGroupId)availableDataRegionGroupCounter.getKeyWithMinValue();
            seriesPartitionTable.putDataPartition(timePartitionSlot, greedyGroupId);
            availableDataRegionGroupCounter.put((Object)greedyGroupId, (Comparable)Integer.valueOf((Integer)availableDataRegionGroupCounter.get((Object)greedyGroupId) + 1));
            LOGGER.warn("[PartitionBalancer] The SeriesSlot: {} in TimeSlot: {} will be allocated to DataRegionGroup: {}, because the original target: {} is currently unavailable.", new Object[]{seriesPartitionSlot, timePartitionSlot, greedyGroupId, allotGroupId});
        }
    }

    private void shuffleAllocationStrategy(String database, TSeriesPartitionSlot seriesPartitionSlot, List<TTimePartitionSlot> timePartitionSlots, BalanceTreeMap<TConsensusGroupId, Integer> availableDataRegionGroupCounter, SeriesPartitionTable seriesPartitionTable) {
        Random random = new Random();
        ArrayList availableDataRegionGroups = new ArrayList(availableDataRegionGroupCounter.keySet());
        for (TTimePartitionSlot timePartitionSlot : timePartitionSlots) {
            TConsensusGroupId targetGroupId;
            if (availableDataRegionGroups.size() == 1) {
                seriesPartitionTable.putDataPartition(timePartitionSlot, (TConsensusGroupId)availableDataRegionGroups.iterator().next());
                continue;
            }
            TConsensusGroupId predecessor = this.getPartitionManager().getPredecessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
            TConsensusGroupId successor = this.getPartitionManager().getSuccessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
            if (predecessor != null && successor != null && !predecessor.equals(successor) && availableDataRegionGroups.size() == 2) {
                seriesPartitionTable.putDataPartition(timePartitionSlot, random.nextBoolean() ? successor : predecessor);
                continue;
            }
            while ((targetGroupId = (TConsensusGroupId)availableDataRegionGroups.get(random.nextInt(availableDataRegionGroups.size()))).equals(predecessor) || targetGroupId.equals(successor)) {
            }
            seriesPartitionTable.putDataPartition(timePartitionSlot, targetGroupId);
        }
    }

    public void reBalanceDataPartitionPolicy(String database) {
        try {
            DataPartitionPolicyTable dataPartitionPolicyTable = this.dataPartitionPolicyTableMap.computeIfAbsent(database, empty -> new DataPartitionPolicyTable());
            try {
                dataPartitionPolicyTable.acquireLock();
                dataPartitionPolicyTable.reBalanceDataPartitionPolicy(this.getPartitionManager().getAllRegionGroupIds(database, TConsensusGroupType.DataRegion));
                dataPartitionPolicyTable.logDataAllotTable(database);
            }
            finally {
                dataPartitionPolicyTable.releaseLock();
            }
        }
        catch (DatabaseNotExistsException e) {
            LOGGER.error("Database {} not exists when updateDataAllotTable", (Object)database);
        }
    }

    public void setupPartitionBalancer() {
        this.dataPartitionPolicyTableMap.clear();
        this.getClusterSchemaManager().getDatabaseNames().forEach(database -> {
            DataPartitionPolicyTable dataPartitionPolicyTable = new DataPartitionPolicyTable();
            this.dataPartitionPolicyTableMap.put((String)database, dataPartitionPolicyTable);
            try {
                dataPartitionPolicyTable.acquireLock();
                dataPartitionPolicyTable.reBalanceDataPartitionPolicy(this.getPartitionManager().getAllRegionGroupIds((String)database, TConsensusGroupType.DataRegion));
                dataPartitionPolicyTable.setDataAllotMap(this.getPartitionManager().getLastDataAllotTable((String)database));
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.error("Database {} not exists when setupPartitionBalancer", database);
            }
            finally {
                dataPartitionPolicyTable.releaseLock();
            }
        });
    }

    public void clearPartitionBalancer() {
        this.dataPartitionPolicyTableMap.clear();
    }

    public void clearDataPartitionPolicyTable(String database) {
        this.dataPartitionPolicyTableMap.remove(database);
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private static enum DataPartitionAllocationStrategy {
        INHERIT,
        SHUFFLE;

    }
}

