/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryDataDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=570");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=572");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=571");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15200");
    private final RelativePath relativePath;
    private final UInteger attributeId;
    private final String indexRange;

    public QueryDataDescription(RelativePath relativePath, UInteger attributeId, String indexRange) {
        this.relativePath = relativePath;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public UInteger getAttributeId() {
        return this.attributeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    protected QueryDataDescription(QueryDataDescriptionBuilder<?, ?> b) {
        super(b);
        this.relativePath = ((QueryDataDescriptionBuilder)b).relativePath;
        this.attributeId = ((QueryDataDescriptionBuilder)b).attributeId;
        this.indexRange = ((QueryDataDescriptionBuilder)b).indexRange;
    }

    public static QueryDataDescriptionBuilder<?, ?> builder() {
        return new QueryDataDescriptionBuilderImpl();
    }

    public QueryDataDescriptionBuilder<?, ?> toBuilder() {
        return new QueryDataDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryDataDescription)) {
            return false;
        }
        QueryDataDescription other = (QueryDataDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelativePath this$relativePath = this.getRelativePath();
        RelativePath other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !((Object)this$relativePath).equals(other$relativePath)) {
            return false;
        }
        UInteger this$attributeId = this.getAttributeId();
        UInteger other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        String this$indexRange = this.getIndexRange();
        String other$indexRange = other.getIndexRange();
        return !(this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryDataDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelativePath $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : ((Object)$relativePath).hashCode());
        UInteger $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        String $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryDataDescription(relativePath=" + this.getRelativePath() + ", attributeId=" + this.getAttributeId() + ", indexRange=" + this.getIndexRange() + ")";
    }

    private static final class QueryDataDescriptionBuilderImpl
    extends QueryDataDescriptionBuilder<QueryDataDescription, QueryDataDescriptionBuilderImpl> {
        private QueryDataDescriptionBuilderImpl() {
        }

        @Override
        protected QueryDataDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public QueryDataDescription build() {
            return new QueryDataDescription(this);
        }
    }

    public static abstract class QueryDataDescriptionBuilder<C extends QueryDataDescription, B extends QueryDataDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RelativePath relativePath;
        private UInteger attributeId;
        private String indexRange;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QueryDataDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(QueryDataDescription instance, QueryDataDescriptionBuilder<?, ?> b) {
            b.relativePath(instance.relativePath);
            b.attributeId(instance.attributeId);
            b.indexRange(instance.indexRange);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B relativePath(RelativePath relativePath) {
            this.relativePath = relativePath;
            return (B)this.self();
        }

        public B attributeId(UInteger attributeId) {
            this.attributeId = attributeId;
            return (B)this.self();
        }

        public B indexRange(String indexRange) {
            this.indexRange = indexRange;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "QueryDataDescription.QueryDataDescriptionBuilder(super=" + super.toString() + ", relativePath=" + this.relativePath + ", attributeId=" + this.attributeId + ", indexRange=" + this.indexRange + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryDataDescription> {
        @Override
        public Class<QueryDataDescription> getType() {
            return QueryDataDescription.class;
        }

        @Override
        public QueryDataDescription decode(SerializationContext context, UaDecoder decoder) {
            RelativePath relativePath = (RelativePath)decoder.readStruct("RelativePath", RelativePath.TYPE_ID);
            UInteger attributeId = decoder.readUInt32("AttributeId");
            String indexRange = decoder.readString("IndexRange");
            return new QueryDataDescription(relativePath, attributeId, indexRange);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryDataDescription value) {
            encoder.writeStruct("RelativePath", (Object)value.getRelativePath(), RelativePath.TYPE_ID);
            encoder.writeUInt32("AttributeId", value.getAttributeId());
            encoder.writeString("IndexRange", value.getIndexRange());
        }
    }
}

