/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class CreateSchemaPartitionPlan
extends ConfigPhysicalPlan {
    private Map<String, SchemaPartitionTable> assignedSchemaPartition;

    public CreateSchemaPartitionPlan() {
        super(ConfigPhysicalPlanType.CreateSchemaPartition);
    }

    public Map<String, SchemaPartitionTable> getAssignedSchemaPartition() {
        return this.assignedSchemaPartition;
    }

    public void setAssignedSchemaPartition(Map<String, SchemaPartitionTable> assignedSchemaPartition) {
        this.assignedSchemaPartition = assignedSchemaPartition;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        try {
            TIOStreamTransport transport = new TIOStreamTransport((OutputStream)stream);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            stream.writeShort(this.getType().getPlanType());
            stream.writeInt(this.assignedSchemaPartition.size());
            for (Map.Entry<String, SchemaPartitionTable> schemaPartitionTableEntry : this.assignedSchemaPartition.entrySet()) {
                BasicStructureSerDeUtil.write((String)schemaPartitionTableEntry.getKey(), (DataOutputStream)stream);
                schemaPartitionTableEntry.getValue().serialize((OutputStream)stream, (TProtocol)protocol);
            }
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.assignedSchemaPartition = new HashMap<String, SchemaPartitionTable>();
        int storageGroupNum = buffer.getInt();
        for (int i = 0; i < storageGroupNum; ++i) {
            String storageGroup = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            SchemaPartitionTable schemaPartitionTable = new SchemaPartitionTable();
            schemaPartitionTable.deserialize(buffer);
            this.assignedSchemaPartition.put(storageGroup, schemaPartitionTable);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSchemaPartitionPlan that = (CreateSchemaPartitionPlan)o;
        return this.assignedSchemaPartition.equals(that.assignedSchemaPartition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assignedSchemaPartition);
    }
}

