/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.consensus.index.ComparableConsensusRequest;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.SearchNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class InsertNode
extends SearchNode
implements ComparableConsensusRequest {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected PartialPath devicePath;
    protected boolean isAligned;
    protected MeasurementSchema[] measurementSchemas;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected int failedMeasurementNumber = 0;
    protected IDeviceID deviceID;
    protected boolean isGeneratedByRemoteConsensusLeader = false;
    protected TRegionReplicaSet dataRegionReplicaSet;
    protected ProgressIndex progressIndex;
    protected long memorySize;
    private static final DeviceIDFactory deviceIDFactory = DeviceIDFactory.getInstance();

    protected InsertNode(PlanNodeId id) {
        super(id);
    }

    @Override
    public final SearchNode merge(List<SearchNode> searchNodes) {
        if (searchNodes.isEmpty()) {
            throw new IllegalArgumentException("insertNodes should never be empty");
        }
        if (searchNodes.size() == 1) {
            return searchNodes.get(0);
        }
        List<InsertNode> insertNodes = searchNodes.stream().map(searchNode -> (InsertNode)searchNode).collect(Collectors.toList());
        InsertNode result = this.mergeInsertNode(insertNodes);
        result.setSearchIndex(insertNodes.get(0).getSearchIndex());
        result.setDevicePath(insertNodes.get(0).getDevicePath());
        return result;
    }

    public abstract InsertNode mergeInsertNode(List<InsertNode> var1);

    protected InsertNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes) {
        super(id);
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
    }

    public TRegionReplicaSet getDataRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public void setDataRegionReplicaSet(TRegionReplicaSet dataRegionReplicaSet) {
        this.dataRegionReplicaSet = dataRegionReplicaSet;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(PartialPath devicePath) {
        this.devicePath = devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public MeasurementSchema[] getMeasurementSchemas() {
        return this.measurementSchemas;
    }

    public void setMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        this.measurementSchemas = measurementSchemas;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public TSDataType getDataType(int index) {
        return this.dataTypes[index];
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public IDeviceID getDeviceID() {
        if (this.deviceID == null) {
            this.deviceID = deviceIDFactory.getDeviceID(this.devicePath);
        }
        return this.deviceID;
    }

    public void setDeviceID(IDeviceID deviceID) {
        this.deviceID = deviceID;
    }

    public boolean isDeviceIDExists() {
        return this.deviceID != null;
    }

    public boolean isGeneratedByRemoteConsensusLeader() {
        switch (config.getDataRegionConsensusProtocolClass()) {
            case "org.apache.iotdb.consensus.iot.IoTConsensus": 
            case "org.apache.iotdb.consensus.iot.IoTConsensusV2": 
            case "org.apache.iotdb.consensus.iot.FastIoTConsensus": 
            case "org.apache.iotdb.consensus.ratis.RatisConsensus": {
                return this.isGeneratedByRemoteConsensusLeader;
            }
            case "org.apache.iotdb.consensus.simple.SimpleConsensus": {
                return false;
            }
        }
        return false;
    }

    public void markAsGeneratedByRemoteConsensusLeader() {
        this.isGeneratedByRemoteConsensusLeader = true;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    protected int serializeMeasurementSchemasSize() {
        int byteLen = 0;
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            byteLen += WALWriteUtils.sizeToWrite(this.measurementSchemas[i]);
        }
        return byteLen;
    }

    protected void serializeMeasurementSchemasToWAL(IWALByteBufferView buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            WALWriteUtils.write(this.measurementSchemas[i], buffer);
        }
    }

    protected void deserializeMeasurementSchemas(DataInputStream stream) throws IOException {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((InputStream)stream);
            this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
            this.dataTypes[i] = this.measurementSchemas[i].getType();
        }
    }

    protected void deserializeMeasurementSchemas(ByteBuffer buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
            this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
        }
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public abstract long getMinTime();

    public void markFailedMeasurement(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean hasValidMeasurements() {
        for (String o : this.measurements) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public void setFailedMeasurementNumber(int failedMeasurementNumber) {
        this.failedMeasurementNumber = failedMeasurementNumber;
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurementNumber;
    }

    public boolean allMeasurementFailed() {
        if (this.measurements != null) {
            return this.failedMeasurementNumber >= this.measurements.length;
        }
        return true;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex;
    }

    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertNode that = (InsertNode)o;
        return this.isAligned == that.isAligned && Objects.equals(this.devicePath, that.devicePath) && Arrays.equals(this.measurementSchemas, that.measurementSchemas) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.deviceID, that.deviceID) && Objects.equals(this.dataRegionReplicaSet, that.dataRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.devicePath, this.isAligned, this.deviceID, this.dataRegionReplicaSet);
        result = 31 * result + Arrays.hashCode(this.measurementSchemas);
        result = 31 * result + Arrays.hashCode(this.measurements);
        result = 31 * result + Arrays.hashCode(this.dataTypes);
        return result;
    }

    public long getMemorySize() {
        if (this.memorySize == 0L) {
            this.memorySize = InsertNodeMemoryEstimator.sizeOf(this);
        }
        return this.memorySize;
    }
}

