/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.data.AsyncImportData;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.tsfile.ImportTsFile;
import org.apache.tsfile.enums.TSDataType;

public class ImportData
extends AbstractDataTool {
    private static final String FILE_ARGS = "s";
    private static final String FILE_NAME = "source";
    private static final String ON_SUCCESS_ARGS = "os";
    private static final String ON_SUCCESS_NAME = "on_success";
    private static final String SUCCESS_DIR_ARGS = "sd";
    private static final String SUCCESS_DIR_NAME = "success_dir";
    private static final String FAIL_DIR_ARGS = "fd";
    private static final String FAIL_DIR_NAME = "fail_dir";
    private static final String ON_FAIL_ARGS = "of";
    private static final String ON_FAIL_NAME = "on_fail";
    private static final String THREAD_NUM_ARGS = "tn";
    private static final String THREAD_NUM_NAME = "thread_num";
    private static final String BATCH_POINT_SIZE_ARGS = "batch";
    private static final String BATCH_POINT_SIZE_NAME = "batch_size";
    private static final String BATCH_POINT_SIZE_ARGS_NAME = "batch_size";
    private static final String ALIGNED_ARGS = "aligned";
    private static final String ALIGNED_NAME = "use_aligned";
    private static final String ALIGNED_ARGS_NAME = "use the aligned interface";
    private static final String TIMESTAMP_PRECISION_ARGS = "tp";
    private static final String TIMESTAMP_PRECISION_NAME = "timestamp_precision";
    private static final String TIMESTAMP_PRECISION_ARGS_NAME = "timestamp precision (ms/us/ns)";
    private static final String TYPE_INFER_ARGS = "ti";
    private static final String TYPE_INFER_NAME = "type_infer";
    private static final String LINES_PER_FAILED_FILE_ARGS = "lpf";
    private static final String LINES_PER_FAILED_FILE_ARGS_NAME = "lines_per_failed_file";
    private static final String TSFILEDB_CLI_PREFIX = "Import Data";
    private static final String TSFILEDB_CLI_HEAD = "Please obtain help information for the corresponding data type based on different parameters, for example:\n./import_data.sh -help tsfile\n./import_data.sh -help sql\n./import_data.sh -help csv";
    private static String targetPath;
    private static String fileType;
    private static Boolean aligned;
    private static int threadNum;
    private static SessionPool sessionPool;
    private static final IoTPrinter ioTPrinter;

    private static Options createTsFileOptions() {
        Options options = ImportData.createImportOptions();
        Option opFile = Option.builder((String)FILE_ARGS).required().longOpt(FILE_NAME).argName(FILE_NAME).hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)ON_SUCCESS_ARGS).longOpt(ON_SUCCESS_NAME).argName(ON_SUCCESS_NAME).required().hasArg().desc("When loading tsfile successfully, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnSuccess);
        Option opSuccessDir = Option.builder((String)SUCCESS_DIR_ARGS).longOpt(SUCCESS_DIR_NAME).argName(SUCCESS_DIR_NAME).hasArg().desc("The target folder when 'os' is 'mv' or 'cp'.(optional)").build();
        options.addOption(opSuccessDir);
        Option opOnFail = Option.builder((String)ON_FAIL_ARGS).longOpt(ON_FAIL_NAME).argName(ON_FAIL_NAME).required().hasArg().desc("When loading tsfile fail, do operation on tsfile (and its .resource and .mods files), optional parameters are none, mv, cp, delete. (required)").build();
        options.addOption(opOnFail);
        Option opFailDir = Option.builder((String)FAIL_DIR_ARGS).longOpt(FAIL_DIR_NAME).argName(FAIL_DIR_NAME).hasArg().desc("The target folder when 'of' is 'mv' or 'cp'.(optional)").build();
        options.addOption(opFailDir);
        Option opThreadNum = Option.builder((String)THREAD_NUM_ARGS).longOpt(THREAD_NUM_NAME).argName(THREAD_NUM_NAME).hasArg().desc("The number of threads used to import tsfile, default is 8.(optional)").build();
        options.addOption(opThreadNum);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opTimestampPrecision = Option.builder((String)TIMESTAMP_PRECISION_ARGS).longOpt(TIMESTAMP_PRECISION_NAME).argName(TIMESTAMP_PRECISION_ARGS_NAME).hasArg().desc("Timestamp precision (ms/us/ns) (optional)").build();
        options.addOption(opTimestampPrecision);
        return options;
    }

    private static Options createCsvOptions() {
        Options options = ImportData.createImportOptions();
        Option opFile = Option.builder((String)FILE_ARGS).longOpt(FILE_NAME).argName(FILE_NAME).required().hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailDir = Option.builder((String)FAIL_DIR_ARGS).longOpt(FAIL_DIR_NAME).argName(FAIL_DIR_NAME).hasArg().desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH (optional)").build();
        options.addOption(opFailDir);
        Option opFailedLinesPerFile = Option.builder((String)LINES_PER_FAILED_FILE_ARGS).longOpt(LINES_PER_FAILED_FILE_ARGS_NAME).argName(LINES_PER_FAILED_FILE_ARGS_NAME).hasArgs().desc("Lines per failed file (optional)").build();
        options.addOption(opFailedLinesPerFile);
        Option opAligned = Option.builder((String)ALIGNED_ARGS).longOpt(ALIGNED_NAME).argName(ALIGNED_ARGS_NAME).hasArg().desc("Whether to use the interface of aligned (optional)").build();
        options.addOption(opAligned);
        Option opTypeInfer = Option.builder((String)TYPE_INFER_ARGS).longOpt(TYPE_INFER_NAME).argName(TYPE_INFER_NAME).numberOfArgs(5).hasArgs().valueSeparator(',').desc("Define type info by option:\"boolean=text,int=long, ... (optional)").build();
        options.addOption(opTypeInfer);
        Option opTimestampPrecision = Option.builder((String)TIMESTAMP_PRECISION_ARGS).longOpt(TIMESTAMP_PRECISION_NAME).argName(TIMESTAMP_PRECISION_ARGS_NAME).hasArg().desc("Timestamp precision (ms/us/ns) (optional)").build();
        options.addOption(opTimestampPrecision);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)BATCH_POINT_SIZE_ARGS).longOpt("batch_size").argName("batch_size").hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opThreadNum = Option.builder((String)THREAD_NUM_ARGS).longOpt(THREAD_NUM_NAME).argName(THREAD_NUM_NAME).hasArg().desc("The number of threads used to import tsfile, default is 8. (optional)").build();
        options.addOption(opThreadNum);
        return options;
    }

    private static Options createSqlOptions() {
        Options options = ImportData.createImportOptions();
        Option opFile = Option.builder((String)FILE_ARGS).required().longOpt(FILE_NAME).argName(FILE_NAME).hasArg().desc("The local directory path of the script file (folder) to be loaded. (required)").build();
        options.addOption(opFile);
        Option opFailDir = Option.builder((String)FAIL_DIR_ARGS).longOpt(FAIL_DIR_NAME).argName(FAIL_DIR_NAME).hasArg().desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH (optional)").build();
        options.addOption(opFailDir);
        Option opFailedLinesPerFile = Option.builder((String)LINES_PER_FAILED_FILE_ARGS).argName(LINES_PER_FAILED_FILE_ARGS_NAME).hasArgs().desc("Lines per failed file (optional)").build();
        options.addOption(opFailedLinesPerFile);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)BATCH_POINT_SIZE_ARGS).longOpt("batch_size").argName("batch_size").hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opThreadNum = Option.builder((String)THREAD_NUM_ARGS).longOpt(THREAD_NUM_NAME).argName(THREAD_NUM_NAME).hasArgs().desc("The number of threads used to import tsfile, default is 8. (optional)").build();
        options.addOption(opThreadNum);
        return options;
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        String[] opTypeInferValues;
        timeZoneID = commandLine.getOptionValue("tz");
        targetPath = commandLine.getOptionValue(FILE_ARGS);
        if (commandLine.getOptionValue(BATCH_POINT_SIZE_ARGS) != null) {
            batchPointSize = Integer.parseInt(commandLine.getOptionValue(BATCH_POINT_SIZE_ARGS));
        }
        if (commandLine.getOptionValue(FAIL_DIR_ARGS) != null) {
            failedFileDirectory = commandLine.getOptionValue(FAIL_DIR_ARGS);
            File file = new File(failedFileDirectory);
            if (!file.isDirectory()) {
                file.mkdir();
                failedFileDirectory = file.getAbsolutePath() + File.separator;
            } else if (!failedFileDirectory.endsWith("/") && !failedFileDirectory.endsWith("\\")) {
                failedFileDirectory = failedFileDirectory + File.separator;
            }
        }
        if (commandLine.getOptionValue(ALIGNED_ARGS) != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue(ALIGNED_ARGS));
        }
        if (commandLine.getOptionValue(THREAD_NUM_ARGS) != null && (threadNum = Integer.parseInt(commandLine.getOptionValue(THREAD_NUM_ARGS))) <= 0) {
            ioTPrinter.println(String.format("error: Invalid thread number '%s'. Please set a positive integer.", threadNum));
            System.exit(1);
        }
        if (commandLine.getOptionValue(TIMESTAMP_PRECISION_ARGS) != null) {
            timestampPrecision = commandLine.getOptionValue(TIMESTAMP_PRECISION_ARGS);
        }
        if ((opTypeInferValues = commandLine.getOptionValues(TYPE_INFER_ARGS)) != null && opTypeInferValues.length > 0) {
            for (String opTypeInferValue : opTypeInferValues) {
                if (!opTypeInferValue.contains("=")) continue;
                String[] typeInfoExpressionArr = opTypeInferValue.split("=");
                String key = typeInfoExpressionArr[0];
                String value = typeInfoExpressionArr[1];
                ImportData.applyTypeInferArgs(key, value);
            }
        }
        if (commandLine.getOptionValue(LINES_PER_FAILED_FILE_ARGS) != null) {
            linesPerFailedFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FAILED_FILE_ARGS));
        }
    }

    private static void applyTypeInferArgs(String key, String value) throws ArgsErrorException {
        if (!TYPE_INFER_KEY_DICT.containsKey(key)) {
            throw new ArgsErrorException("Unknown type infer key: " + key);
        }
        if (!TYPE_INFER_VALUE_DICT.containsKey(value)) {
            throw new ArgsErrorException("Unknown type infer value: " + value);
        }
        if (!(!key.equals("NaN") || value.equals("float") || value.equals("double") || value.equals("text") || value.equals("string"))) {
            throw new ArgsErrorException("NaN can not convert to " + value);
        }
        if (key.equals("boolean") && !value.equals("boolean") && !value.equals("text") && !value.equals("string")) {
            throw new ArgsErrorException("Boolean can not convert to " + value);
        }
        if (key.equals("date") && !value.equals("date") && !value.equals("text") && !value.equals("string")) {
            throw new ArgsErrorException("Date can not convert to " + value);
        }
        if (!(!key.equals("timestamp") || value.equals("timestamp") || value.equals("text") || value.equals("string") || value.equals("double") || value.equals("long"))) {
            throw new ArgsErrorException("Timestamp can not convert to " + value);
        }
        if (key.equals("blob") && !value.equals("blob")) {
            throw new ArgsErrorException("Blob can not convert to " + value);
        }
        TSDataType srcType = (TSDataType)TYPE_INFER_VALUE_DICT.get(key);
        TSDataType dstType = (TSDataType)TYPE_INFER_VALUE_DICT.get(value);
        if (dstType.getType() < srcType.getType()) {
            throw new ArgsErrorException(key + " can not convert to " + value);
        }
        TYPE_INFER_KEY_DICT.put(key, (TSDataType)TYPE_INFER_VALUE_DICT.get(value));
    }

    public static void main(String[] args) throws IoTDBConnectionException {
        Options helpOptions = ImportData.createHelpOptions();
        Options tsFileOptions = ImportData.createTsFileOptions();
        Options csvOptions = ImportData.createCsvOptions();
        Options sqlOptions = ImportData.createSqlOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            ImportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(helpOptions, args, true);
        }
        catch (ParseException e) {
            ImportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        List<String> argList = Arrays.asList(args);
        int helpIndex = argList.indexOf("-help");
        int ftIndex = argList.indexOf("-ft");
        if (ftIndex < 0) {
            ftIndex = argList.indexOf("-file_type");
        }
        if (helpIndex >= 0) {
            fileType = argList.get(helpIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, null, null, false);
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, csvOptions, null, false);
                } else if ("sql".equalsIgnoreCase(fileType)) {
                    ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, null, sqlOptions, false);
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ImportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
                }
            } else {
                ImportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
            }
            System.exit(1);
        } else if (ftIndex >= 0) {
            fileType = argList.get(ftIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(tsFileOptions, args);
                        ImportTsFile.importData(commandLine);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, null, null, false);
                        System.exit(1);
                    }
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(csvOptions, args);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, csvOptions, null, false);
                        System.exit(1);
                    }
                } else if ("sql".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(sqlOptions, args);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, null, sqlOptions, false);
                        System.exit(1);
                    }
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ImportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
                    System.exit(1);
                }
            } else {
                ioTPrinter.println(String.format("Invalid args: Required values for option '%s' not provided", "file_type"));
                System.exit(1);
            }
        } else {
            ioTPrinter.println(String.format("Invalid args: Required values for option '%s' not provided", "file_type"));
            System.exit(1);
        }
        try {
            ImportData.parseBasicParams(commandLine);
            String filename = commandLine.getOptionValue(FILE_ARGS);
            if (filename == null) {
                ioTPrinter.println(TSFILEDB_CLI_HEAD);
                ImportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
                System.exit(1);
            }
            ImportData.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Args error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            ioTPrinter.println("Encounter an error, because: " + e.getMessage());
            System.exit(1);
        }
        int resultCode = ImportData.importFromTargetPathAsync();
        if (ImportDataScanTool.getTsFileQueueSize() <= 0) {
            System.exit(0);
        }
        ImportData.asyncImportDataFiles();
        System.exit(resultCode);
    }

    private static void asyncImportDataFiles() {
        ArrayList<Thread> list = new ArrayList<Thread>(threadNum);
        for (int i = 0; i < threadNum; ++i) {
            Thread thread2 = new Thread(new AsyncImportData());
            thread2.start();
            list.add(thread2);
        }
        list.forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ioTPrinter.println("ImportData thread join interrupted: " + e.getMessage());
            }
        });
        ioTPrinter.println("Import completely!");
    }

    private static int importFromTargetPathAsync() {
        try {
            sessionPool = new SessionPool.Builder().host(host).port(Integer.parseInt(port)).user(username).password(password).maxSize(threadNum + 1).enableCompression(false).enableRedirection(false).enableAutoFetch(false).build();
            sessionPool.setEnableQueryRedirection(false);
            AsyncImportData.setAligned(aligned);
            AsyncImportData.setSessionPool(sessionPool);
            AsyncImportData.setTimeZone();
            ImportDataScanTool.setSourceFullPath(targetPath);
            File file = new File(targetPath);
            if (!file.isFile() && !file.isDirectory()) {
                ioTPrinter.println(String.format("Source file or directory %s does not exist", targetPath));
                System.exit(1);
            }
            ImportDataScanTool.traverseAndCollectFiles();
            ImportData.asyncImportDataFiles();
            return 0;
        }
        catch (InterruptedException e) {
            ioTPrinter.println(String.format("Import tsfile fail: %s", e.getMessage()));
            Thread.currentThread().interrupt();
            return 1;
        }
        catch (Exception e) {
            ioTPrinter.println(String.format("Import tsfile fail: %s", e.getMessage()));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importFromTargetPath(String host, int port, String username, String password, String targetPath, String timeZone) throws IoTDBConnectionException {
        block14: {
            try {
                session = new Session(host, port, username, password, false);
                session.open(false);
                timeZoneID = timeZone;
                ImportData.setTimeZone();
                File file = new File(targetPath);
                if (file.isFile()) {
                    if (file.getName().endsWith("sql")) {
                        ImportData.importFromSqlFile(session, file);
                    } else {
                        ImportData.importFromSingleFile(session, file);
                    }
                    break block14;
                }
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) {
                        int n = 0;
                        return n;
                    }
                    for (File subFile : files) {
                        if (!subFile.isFile()) continue;
                        if (subFile.getName().endsWith("sql")) {
                            ImportData.importFromSqlFile(session, subFile);
                            continue;
                        }
                        ImportData.importFromSingleFile(session, subFile);
                    }
                    break block14;
                }
                ioTPrinter.println("File not found!");
                int n = 1;
                return n;
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                ioTPrinter.println("Encounter an error when connecting to server, because " + e.getMessage());
                int n = 1;
                return n;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return 0;
    }

    private static void importFromSingleFile(Session session, File file) {
        block7: {
            if (file.getName().endsWith("csv") || file.getName().endsWith("txt")) {
                try {
                    CSVParser csvRecords = ImportData.readCsvFile(file.getAbsolutePath());
                    List headerNames = csvRecords.getHeaderNames();
                    Stream records = csvRecords.stream();
                    if (headerNames.isEmpty()) {
                        ioTPrinter.println("Empty file!");
                        return;
                    }
                    if (!timeColumn.equalsIgnoreCase(ImportData.filterBomHeader((String)headerNames.get(0)))) {
                        ioTPrinter.println("The first field of header must be `Time`!");
                        return;
                    }
                    String failedFilePath = null;
                    failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                    if (!deviceColumn.equalsIgnoreCase((String)headerNames.get(1))) {
                        ImportData.writeDataAlignedByTime(session, (List<String>)headerNames, (Stream<CSVRecord>)records, failedFilePath);
                        break block7;
                    }
                    ImportData.writeDataAlignedByDevice(session, (List<String>)headerNames, (Stream<CSVRecord>)records, failedFilePath);
                }
                catch (IOException | IllegalPathException e) {
                    ioTPrinter.println("CSV file read exception because: " + e.getMessage());
                }
            } else {
                ioTPrinter.println("The file name must end with \"csv\" or \"txt\"!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importFromSqlFile(Session session, File file) {
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        String failedFilePath = null;
        failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
        try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));){
            Object sql;
            while ((sql = br.readLine()) != null) {
                try {
                    session.executeNonQueryStatement((String)sql);
                }
                catch (IoTDBConnectionException | StatementExecutionException throwable) {
                    failedRecords.add(Arrays.asList(sql));
                }
            }
            ioTPrinter.println(file.getName() + " Import completely!");
        }
        catch (IOException e) {
            ioTPrinter.println("SQL file read exception because: " + e.getMessage());
        }
        if (!failedRecords.isEmpty()) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(failedFilePath);
                for (List list : failedRecords) {
                    writer.write(list.get(0).toString() + "\n");
                }
            }
            catch (IOException e) {
                ioTPrinter.println("Cannot dump fail result because: " + e.getMessage());
            }
            finally {
                if (ObjectUtils.isNotEmpty((Object)writer)) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    static {
        fileType = null;
        aligned = false;
        threadNum = 8;
        ioTPrinter = new IoTPrinter(System.out);
    }
}

