/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.james.mailbox.model.MessageId;

public class DeleteResult {
    private final Set<MessageId> destroyed;
    private final Set<MessageId> notFound;

    public static Builder builder() {
        return new Builder();
    }

    public static DeleteResult destroyed(MessageId messageId) {
        return new Builder().addDestroyed(messageId).build();
    }

    public static DeleteResult notFound(MessageId messageId) {
        return new Builder().addNotFound(messageId).build();
    }

    public DeleteResult(Set<MessageId> destroyed, Set<MessageId> notFound) {
        this.destroyed = destroyed;
        this.notFound = notFound;
    }

    public Set<MessageId> getDestroyed() {
        return this.destroyed;
    }

    public Set<MessageId> getNotFound() {
        return this.notFound;
    }

    public final boolean equals(Object o) {
        if (o instanceof DeleteResult) {
            DeleteResult result = (DeleteResult)o;
            return Objects.equals(this.destroyed, result.destroyed) && Objects.equals(this.notFound, result.notFound);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.destroyed, this.notFound);
    }

    public static class Builder {
        private final ImmutableSet.Builder<MessageId> destroyed = ImmutableSet.builder();
        private final ImmutableSet.Builder<MessageId> notFound = ImmutableSet.builder();

        public Builder addDestroyed(Collection<MessageId> messageIds) {
            this.destroyed.addAll(messageIds);
            return this;
        }

        public Builder addNotFound(Collection<MessageId> messageIds) {
            this.notFound.addAll(messageIds);
            return this;
        }

        public Builder addDestroyed(MessageId messageId) {
            this.destroyed.add((Object)messageId);
            return this;
        }

        public Builder addNotFound(MessageId messageId) {
            this.notFound.add((Object)messageId);
            return this;
        }

        public DeleteResult build() {
            return new DeleteResult((Set<MessageId>)((Object)this.destroyed.build()), (Set<MessageId>)((Object)this.notFound.build()));
        }
    }
}

