/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Jwe;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwtVisitor;
import io.jsonwebtoken.impl.DefaultProtectedJwt;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import java.security.MessageDigest;

public class DefaultJwe<P>
extends DefaultProtectedJwt<JweHeader, P>
implements Jwe<P> {
    private static final String DIGEST_NAME = "tag";
    private final byte[] iv;

    public DefaultJwe(JweHeader header, P payload, byte[] iv, byte[] aadTag) {
        super(header, payload, aadTag, DIGEST_NAME);
        this.iv = Assert.notEmpty((byte[])iv, (String)"Initialization vector cannot be null or empty.");
    }

    public byte[] getInitializationVector() {
        return (byte[])this.iv.clone();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(",iv=").append((String)Encoders.BASE64URL.encode((Object)this.iv));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Jwe) {
            Jwe jwe = (Jwe)obj;
            return super.equals(jwe) && MessageDigest.isEqual(this.iv, jwe.getInitializationVector());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.nullSafeHashCode((Object[])new Object[]{this.getHeader(), this.getPayload(), this.iv, this.digest});
    }

    @Override
    public <T> T accept(JwtVisitor<T> v) {
        return (T)v.visit((Jwe)this);
    }
}

