/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import java.io.InputStream;
import java.time.ZonedDateTime;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class ResourceLocator {
    private final SieveRepository sieveRepository;
    private final UsersRepository usersRepository;

    public ResourceLocator(SieveRepository sieveRepository, UsersRepository usersRepository) {
        this.sieveRepository = sieveRepository;
        this.usersRepository = usersRepository;
    }

    public UserSieveInformation get(MailAddress mailAddress) throws Exception {
        Username username = this.retrieveUsername(mailAddress);
        return new UserSieveInformation(this.sieveRepository.getActivationDateForActiveScript(username), ZonedDateTime.now(), this.sieveRepository.getActive(username));
    }

    private Username retrieveUsername(MailAddress mailAddress) {
        try {
            return this.usersRepository.getUsername(mailAddress);
        }
        catch (UsersRepositoryException e) {
            return Username.fromMailAddress((MailAddress)mailAddress);
        }
    }

    public static class UserSieveInformation {
        private ZonedDateTime scriptActivationDate;
        private ZonedDateTime scriptInterpretationDate;
        private InputStream scriptContent;

        public UserSieveInformation(ZonedDateTime scriptActivationDate, ZonedDateTime scriptInterpretationDate, InputStream scriptContent) {
            this.scriptActivationDate = scriptActivationDate;
            this.scriptInterpretationDate = scriptInterpretationDate;
            this.scriptContent = scriptContent;
        }

        public ZonedDateTime getScriptActivationDate() {
            return this.scriptActivationDate;
        }

        public ZonedDateTime getScriptInterpretationDate() {
            return this.scriptInterpretationDate;
        }

        public InputStream getScriptContent() {
            return this.scriptContent;
        }
    }
}

