/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Optional;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.redirect.MailModifier;
import org.apache.james.transport.mailets.redirect.MessageAlteringUtils;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.mailet.LoopPrevention;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRedirectNotify {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessRedirectNotify.class);
    private final RedirectNotify mailet;
    private final boolean isDebug;

    public static ProcessRedirectNotify from(RedirectNotify mailet) {
        return new ProcessRedirectNotify(mailet);
    }

    private ProcessRedirectNotify(RedirectNotify mailet) {
        this.mailet = mailet;
        this.isDebug = mailet.getInitParameters().isDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Mail originalMail) throws MessagingException {
        block10: {
            String originalMessageId = originalMail.getMessage().getMessageID();
            MailImpl newMail = MailImpl.duplicate((Mail)originalMail);
            try {
                boolean keepMessageId;
                MailModifier mailModifier = MailModifier.builder().mailet(this.mailet).mail(newMail).dns(this.mailet.getDNSService()).build();
                mailModifier.setRemoteAddr();
                mailModifier.setRemoteHost();
                if (this.mailet.getInitParameters().isDebug()) {
                    LOGGER.debug("New mail - sender: {}, recipients: {}, name: {}, remoteHost: {}, remoteAddr: {}, state: {}, lastUpdated: {}, errorMessage: {}", new Object[]{newMail.getMaybeSender(), newMail.getRecipients(), newMail.getName(), newMail.getRemoteHost(), newMail.getRemoteAddr(), newMail.getState(), newMail.getLastUpdated(), newMail.getErrorMessage()});
                }
                if (!(keepMessageId = this.keepMessageId())) {
                    this.createAlterMessage(originalMail, newMail);
                } else {
                    this.createUnalteredMessage(originalMail, newMail);
                }
                mailModifier.setRecipients(this.mailet.getRecipients(originalMail));
                mailModifier.setTo(this.mailet.getTo(originalMail));
                mailModifier.setSubjectPrefix(originalMail);
                mailModifier.setReplyTo(this.mailet.getReplyTo(originalMail));
                mailModifier.setReversePath(this.mailet.getReversePath(originalMail));
                mailModifier.setIsReply(this.mailet.getInitParameters().isReply(), originalMail);
                mailModifier.setSender(this.mailet.getSender(originalMail));
                mailModifier.initializeDateIfNotPresent();
                if (keepMessageId) {
                    mailModifier.setMessageId(originalMessageId);
                }
                this.finalizeMail(newMail);
                if (this.senderDomainIsValid((Mail)newMail)) {
                    if (!newMail.getRecipients().isEmpty()) {
                        this.mailet.getMailetContext().sendMail((Mail)newMail);
                    }
                    break block10;
                }
                throw new MessagingException(this.mailet.getMailetName() + " mailet cannot forward " + originalMail.getName() + ". Invalid sender domain for " + newMail.getMaybeSender().asString() + ". Consider using the Resend mailet using a different sender.");
            }
            finally {
                newMail.dispose();
            }
        }
        if (!this.mailet.getInitParameters().getPassThrough()) {
            originalMail.setState("ghost");
        }
    }

    private void finalizeMail(MailImpl mail) throws MessagingException {
        mail.getMessage().saveChanges();
        Optional recordedRecipients = mail.getAttribute(LoopPrevention.RECORDED_RECIPIENTS_ATTRIBUTE_NAME);
        mail.removeAllAttributes();
        recordedRecipients.ifPresent(arg_0 -> ((MailImpl)mail).setAttribute(arg_0));
    }

    private boolean keepMessageId() {
        return this.mailet.getInitParameters().getInLineType().equals((Object)TypeCode.UNALTERED);
    }

    private void createAlterMessage(Mail originalMail, MailImpl newMail) throws MessagingException {
        if (this.isDebug) {
            LOGGER.debug("Alter message");
        }
        MimeMessage oldMessage = newMail.getMessage();
        MimeMessage newMessage = MessageAlteringUtils.from(this.mailet).originalMail(originalMail).alteredMessage();
        newMail.setMessage(newMessage);
        LifecycleUtil.dispose((Object)oldMessage);
    }

    private void createUnalteredMessage(Mail originalMail, MailImpl newMail) throws MessagingException {
        if (this.mailet.getInitParameters().getPassThrough()) {
            newMail.setMessage((MimeMessage)new CopiedMimeMessage(originalMail.getMessage()));
        }
        if (this.isDebug) {
            LOGGER.debug("Message resent unaltered.");
        }
    }

    private boolean senderDomainIsValid(Mail mail) {
        return !this.mailet.getInitParameters().getFakeDomainCheck() || !mail.hasSender() || !this.mailet.getMailetContext().getMailServers(mail.getMaybeSender().get().getDomain()).isEmpty();
    }

    private static class CopiedMimeMessage
    extends MimeMessage {
        public CopiedMimeMessage(MimeMessage originalMessage) throws MessagingException {
            super(originalMessage);
        }

        protected void updateHeaders() throws MessagingException {
            if (this.getMessageID() == null) {
                super.updateHeaders();
            } else {
                this.modified = false;
            }
        }
    }
}

