/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.blob;

import jakarta.inject.Inject;
import java.time.Clock;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.james.blob.api.BucketName;

public class BucketNameGenerator {
    private static final Pattern BUCKET_NAME_PATTERN = Pattern.compile("deleted-messages-([0-9]{4})-([0-9]{2})-(01)");
    private static final String BUCKET_NAME_GENERATING_FORMAT = "deleted-messages-%d-%02d-01";
    private final Clock clock;

    @Inject
    public BucketNameGenerator(Clock clock) {
        this.clock = clock;
    }

    BucketName currentBucket() {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        int month = now.getMonthValue();
        int year = now.getYear();
        return BucketName.of((String)String.format(BUCKET_NAME_GENERATING_FORMAT, year, month));
    }

    Optional<ZonedDateTime> bucketEndTime(BucketName bucketName) {
        return Optional.of(BUCKET_NAME_PATTERN.matcher(bucketName.asString())).filter(Matcher::matches).map(matcher -> {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            return this.firstDayOfNextMonth(year, month);
        });
    }

    private ZonedDateTime firstDayOfNextMonth(int year, int month) {
        return LocalDate.of(year, month, 1).plusMonths(1L).atStartOfDay(this.clock.getZone());
    }
}

