/*
 * Decompiled with CFR 0.152.
 */
package reactor.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Delivery;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import reactor.core.publisher.FluxSink;
import reactor.rabbitmq.ExceptionHandlers;
import reactor.rabbitmq.Receiver;

public class ConsumeOptions {
    private int qos = 250;
    private String consumerTag = "";
    private FluxSink.OverflowStrategy overflowStrategy = FluxSink.OverflowStrategy.BUFFER;
    private BiFunction<Long, ? super Delivery, Boolean> hookBeforeEmitBiFunction = (requestedFromDownstream, message) -> true;
    private BiFunction<Long, ? super Delivery, Boolean> stopConsumingBiFunction = (requestedFromDownstream, message) -> false;
    private BiConsumer<Receiver.AcknowledgmentContext, Exception> exceptionHandler = new ExceptionHandlers.RetryAcknowledgmentExceptionHandler(Duration.ofSeconds(10L), Duration.ofMillis(200L), ExceptionHandlers.CONNECTION_RECOVERY_PREDICATE);
    private Consumer<Channel> channelCallback = ch -> {};
    private Map<String, Object> arguments = Collections.emptyMap();

    public int getQos() {
        return this.qos;
    }

    public ConsumeOptions qos(int qos) {
        if (qos < 0) {
            throw new IllegalArgumentException("QoS must be greater or equal to 0");
        }
        this.qos = qos;
        return this;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public ConsumeOptions consumerTag(String consumerTag) {
        if (consumerTag == null) {
            throw new IllegalArgumentException("consumerTag must be non-null");
        }
        this.consumerTag = consumerTag;
        return this;
    }

    public FluxSink.OverflowStrategy getOverflowStrategy() {
        return this.overflowStrategy;
    }

    public ConsumeOptions overflowStrategy(FluxSink.OverflowStrategy overflowStrategy) {
        this.overflowStrategy = overflowStrategy;
        return this;
    }

    public BiFunction<Long, ? super Delivery, Boolean> getHookBeforeEmitBiFunction() {
        return this.hookBeforeEmitBiFunction;
    }

    public ConsumeOptions hookBeforeEmitBiFunction(BiFunction<Long, ? super Delivery, Boolean> hookBeforeEmit) {
        this.hookBeforeEmitBiFunction = hookBeforeEmit;
        return this;
    }

    public BiFunction<Long, ? super Delivery, Boolean> getStopConsumingBiFunction() {
        return this.stopConsumingBiFunction;
    }

    public ConsumeOptions stopConsumingBiFunction(BiFunction<Long, ? super Delivery, Boolean> stopConsumingBiFunction) {
        this.stopConsumingBiFunction = stopConsumingBiFunction;
        return this;
    }

    public ConsumeOptions exceptionHandler(BiConsumer<Receiver.AcknowledgmentContext, Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public BiConsumer<Receiver.AcknowledgmentContext, Exception> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ConsumeOptions channelCallback(Consumer<Channel> channelCallback) {
        this.channelCallback = channelCallback;
        return this;
    }

    public Consumer<Channel> getChannelCallback() {
        return this.channelCallback;
    }

    public ConsumeOptions arguments(Map<String, Object> arguments) {
        this.arguments = arguments;
        return this;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }
}

