/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.MissingOrInvalidKeyException;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.PublicKeyReader;

public class DefaultPublicKeyProvider
implements PublicKeyProvider {
    private final JwtConfiguration jwtConfiguration;
    private final PublicKeyReader reader;

    public DefaultPublicKeyProvider(JwtConfiguration jwtConfiguration, PublicKeyReader reader) {
        this.jwtConfiguration = jwtConfiguration;
        this.reader = reader;
    }

    @Override
    public List<PublicKey> get() throws MissingOrInvalidKeyException {
        ImmutableList keys = (ImmutableList)this.jwtConfiguration.getJwtPublicKeyPem().stream().flatMap(s -> this.reader.fromPEM((String)s).stream()).collect(ImmutableList.toImmutableList());
        if (keys.size() != this.jwtConfiguration.getJwtPublicKeyPem().size()) {
            throw new MissingOrInvalidKeyException();
        }
        return keys;
    }

    @Override
    public Optional<PublicKey> get(String kid) throws MissingOrInvalidKeyException {
        return this.get().stream().filter(k -> DefaultPublicKeyProvider.computeKid(k).equals(kid)).findFirst();
    }

    protected static byte[] unpad(byte[] bytes) {
        return bytes.length > 1 && bytes[0] == 0 && (bytes[1] & 0x80) != 0 ? Arrays.copyOfRange(bytes, 1, bytes.length) : bytes;
    }

    protected static String b64u(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    protected static String toCanonicalJwkJson(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsa = (RSAPublicKey)key;
            String n = DefaultPublicKeyProvider.b64u(DefaultPublicKeyProvider.unpad(rsa.getModulus().toByteArray()));
            String e = DefaultPublicKeyProvider.b64u(DefaultPublicKeyProvider.unpad(rsa.getPublicExponent().toByteArray()));
            return String.format("{\"e\":\"%s\",\"kty\":\"RSA\",\"n\":\"%s\"}", e, n);
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ec = (ECPublicKey)key;
            String crv = "P-" + ec.getParams().getCurve().getField().getFieldSize();
            String x = DefaultPublicKeyProvider.b64u(DefaultPublicKeyProvider.unpad(ec.getW().getAffineX().toByteArray()));
            String y = DefaultPublicKeyProvider.b64u(DefaultPublicKeyProvider.unpad(ec.getW().getAffineY().toByteArray()));
            return String.format("{\"crv\":\"%s\",\"kty\":\"EC\",\"x\":\"%s\",\"y\":\"%s\"}", crv, x, y);
        }
        if (key instanceof EdECPublicKey) {
            EdECPublicKey ed = (EdECPublicKey)key;
            String crv = ed.getParams().getName();
            byte[] encoded = key.getEncoded();
            int pos = 2;
            pos += 2 + encoded[pos + 1] + 1;
            byte len = encoded[pos++];
            byte[] raw = new byte[len - 1];
            System.arraycopy(encoded, ++pos, raw, 0, raw.length);
            String x = DefaultPublicKeyProvider.b64u(raw);
            return String.format("{\"crv\":\"%s\",\"kty\":\"OKP\",\"x\":\"%s\"}", crv, x);
        }
        throw new IllegalArgumentException("Unsupported key algorithm: " + key.getAlgorithm());
    }

    public static String computeKid(PublicKey key) {
        String jwk = DefaultPublicKeyProvider.toCanonicalJwkJson(key);
        byte[] jwkBytes = jwk.getBytes(StandardCharsets.UTF_8);
        try {
            return DefaultPublicKeyProvider.b64u(MessageDigest.getInstance("SHA-256").digest(jwkBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 not available", e);
        }
    }
}

