/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.base.Objects;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

@Immutable
public class ObjectGraphNode
implements GraphNode {
    private final Object delegate;

    public ObjectGraphNode(Object delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isNull() {
        return this.delegate == null;
    }

    @Override
    public boolean isMap() {
        return this.delegate instanceof Map;
    }

    @Override
    public Iterable<?> keys() {
        return ((Map)this.delegate).keySet();
    }

    @Override
    public GraphNode getByKey(Object key) {
        if (!this.isMap()) {
            return null;
        }
        Map map = this.asMap();
        if (map.containsKey(key)) {
            return new ObjectGraphNode(map.get(key));
        }
        return null;
    }

    @Override
    public <K, V> Map<K, V> asMap() {
        return (Map)this.delegate;
    }

    @Override
    public boolean isList() {
        return this.delegate instanceof List;
    }

    @Override
    public int size() {
        if (this.isList()) {
            return this.asList().size();
        }
        if (this.isMap()) {
            return this.asMap().size();
        }
        if (this.isSet()) {
            return this.asSet().size();
        }
        return 0;
    }

    @Override
    public GraphNode getByIndex(int index) {
        if (!this.isList() || index < 0 || index >= this.size()) {
            return null;
        }
        return new ObjectGraphNode(this.asList().get(index));
    }

    @Override
    public <T> List<T> asList() {
        return (List)this.delegate;
    }

    @Override
    public boolean isValue() {
        return !this.isList() && !this.isMap() && !this.isSet() && !this.isVertex() && !this.isEdge() && !this.isPath() && !this.isProperty() && !this.isVertexProperty();
    }

    @Override
    public boolean isVertexProperty() {
        return this.delegate instanceof VertexProperty;
    }

    @Override
    public boolean isProperty() {
        return this.delegate instanceof Property;
    }

    @Override
    public boolean isPath() {
        return this.delegate instanceof Path;
    }

    @Override
    public int asInt() {
        return (Integer)this.delegate;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.delegate;
    }

    @Override
    public long asLong() {
        return (Long)this.delegate;
    }

    @Override
    public double asDouble() {
        return (Double)this.delegate;
    }

    @Override
    public String asString() {
        return (String)this.delegate;
    }

    public <T> T as(Class<T> clazz) {
        return (T)this.delegate;
    }

    public <T> T as(GenericType<T> type) {
        return (T)this.delegate;
    }

    @Override
    public boolean isVertex() {
        return this.delegate instanceof Vertex;
    }

    @Override
    public Vertex asVertex() {
        return (Vertex)this.delegate;
    }

    @Override
    public boolean isEdge() {
        return this.delegate instanceof Edge;
    }

    @Override
    public Edge asEdge() {
        return (Edge)this.delegate;
    }

    @Override
    public Path asPath() {
        return (Path)this.delegate;
    }

    @Override
    public <T> Property<T> asProperty() {
        return (Property)this.delegate;
    }

    @Override
    public <T> VertexProperty<T> asVertexProperty() {
        return (VertexProperty)this.delegate;
    }

    @Override
    public boolean isSet() {
        return this.delegate instanceof Set;
    }

    @Override
    public <T> Set<T> asSet() {
        return (Set)this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ObjectGraphNode && Objects.equal((Object)this.delegate, (Object)((ObjectGraphNode)other).delegate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate});
    }
}

