/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.builder;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ThrowingConsumer;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.util.Collections;
import java.util.Properties;

public class MimeMessageWrapper
extends MimeMessage {
    public static MimeMessageWrapper wrap(MimeMessage mimeMessage) throws MessagingException {
        try {
            return new MimeMessageWrapper(mimeMessage);
        }
        catch (MessagingException e) {
            MimeMessageWrapper result = new MimeMessageWrapper();
            ThrowingConsumer consumer = header -> result.addHeader(header.getName(), header.getValue());
            Collections.list(mimeMessage.getAllHeaders()).forEach(Throwing.consumer((ThrowingConsumer)consumer).sneakyThrow());
            result.setText("");
            return result;
        }
    }

    private MimeMessageWrapper() {
        super(Session.getDefaultInstance((Properties)new Properties()));
    }

    private MimeMessageWrapper(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage);
    }

    protected void updateMessageID() throws MessagingException {
        if (this.getMessageID() == null) {
            super.updateMessageID();
        }
    }
}

