/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.SuggestContext;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class CompletionProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final String analyzer;
    private final List<SuggestContext> contexts;
    @Nullable
    private final Integer maxInputLength;
    @Nullable
    private final Boolean preservePositionIncrements;
    @Nullable
    private final Boolean preserveSeparators;
    @Nullable
    private final String searchAnalyzer;
    public static final JsonpDeserializer<CompletionProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionProperty::setupCompletionPropertyDeserializer);

    private CompletionProperty(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.contexts = ApiTypeHelper.unmodifiable(builder.contexts);
        this.maxInputLength = builder.maxInputLength;
        this.preservePositionIncrements = builder.preservePositionIncrements;
        this.preserveSeparators = builder.preserveSeparators;
        this.searchAnalyzer = builder.searchAnalyzer;
    }

    public static CompletionProperty of(Function<Builder, ObjectBuilder<CompletionProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Completion;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    public final List<SuggestContext> contexts() {
        return this.contexts;
    }

    @Nullable
    public final Integer maxInputLength() {
        return this.maxInputLength;
    }

    @Nullable
    public final Boolean preservePositionIncrements() {
        return this.preservePositionIncrements;
    }

    @Nullable
    public final Boolean preserveSeparators() {
        return this.preserveSeparators;
    }

    @Nullable
    public final String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "completion");
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (ApiTypeHelper.isDefined(this.contexts)) {
            generator.writeKey("contexts");
            generator.writeStartArray();
            for (SuggestContext item0 : this.contexts) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxInputLength != null) {
            generator.writeKey("max_input_length");
            generator.write(this.maxInputLength.intValue());
        }
        if (this.preservePositionIncrements != null) {
            generator.writeKey("preserve_position_increments");
            generator.write(this.preservePositionIncrements.booleanValue());
        }
        if (this.preserveSeparators != null) {
            generator.writeKey("preserve_separators");
            generator.write(this.preserveSeparators.booleanValue());
        }
        if (this.searchAnalyzer != null) {
            generator.writeKey("search_analyzer");
            generator.write(this.searchAnalyzer);
        }
    }

    protected static void setupCompletionPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::contexts, JsonpDeserializer.arrayDeserializer(SuggestContext._DESERIALIZER), "contexts");
        op.add(Builder::maxInputLength, JsonpDeserializer.integerDeserializer(), "max_input_length");
        op.add(Builder::preservePositionIncrements, JsonpDeserializer.booleanDeserializer(), "preserve_position_increments");
        op.add(Builder::preserveSeparators, JsonpDeserializer.booleanDeserializer(), "preserve_separators");
        op.add(Builder::searchAnalyzer, JsonpDeserializer.stringDeserializer(), "search_analyzer");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompletionProperty> {
        @Nullable
        private String analyzer;
        @Nullable
        private List<SuggestContext> contexts;
        @Nullable
        private Integer maxInputLength;
        @Nullable
        private Boolean preservePositionIncrements;
        @Nullable
        private Boolean preserveSeparators;
        @Nullable
        private String searchAnalyzer;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder contexts(List<SuggestContext> list) {
            this.contexts = Builder._listAddAll(this.contexts, list);
            return this;
        }

        public final Builder contexts(SuggestContext value, SuggestContext ... values) {
            this.contexts = Builder._listAdd(this.contexts, value, values);
            return this;
        }

        public final Builder contexts(Function<SuggestContext.Builder, ObjectBuilder<SuggestContext>> fn) {
            return this.contexts(fn.apply(new SuggestContext.Builder()).build(), new SuggestContext[0]);
        }

        public final Builder maxInputLength(@Nullable Integer value) {
            this.maxInputLength = value;
            return this;
        }

        public final Builder preservePositionIncrements(@Nullable Boolean value) {
            this.preservePositionIncrements = value;
            return this;
        }

        public final Builder preserveSeparators(@Nullable Boolean value) {
            this.preserveSeparators = value;
            return this;
        }

        public final Builder searchAnalyzer(@Nullable String value) {
            this.searchAnalyzer = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionProperty build() {
            this._checkSingleUse();
            return new CompletionProperty(this);
        }
    }
}

