/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest.simulate;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Ingest
implements PlainJsonSerializable {
    private final String timestamp;
    @Nullable
    private final String pipeline;
    public static final JsonpDeserializer<Ingest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ingest::setupIngestDeserializer);

    private Ingest(Builder builder) {
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.pipeline = builder.pipeline;
    }

    public static Ingest of(Function<Builder, ObjectBuilder<Ingest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
    }

    protected static void setupIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Ingest> {
        private String timestamp;
        @Nullable
        private String pipeline;

        public final Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        @Override
        public Ingest build() {
            this._checkSingleUse();
            return new Ingest(this);
        }
    }
}

