/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAuthenticationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.BindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedRequestAccessLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class TextFormattedBindRequestAccessLogMessage
extends TextFormattedRequestAccessLogMessage
implements BindRequestAccessLogMessage {
    private static final long serialVersionUID = 8084301781864176576L;
    @Nullable
    private final BindRequestAuthenticationType authenticationType;
    @Nullable
    private final String dn = this.getString(TextFormattedAccessLogFields.BIND_DN);
    @Nullable
    private final String protocolVersion = this.getString(TextFormattedAccessLogFields.BIND_PROTOCOL_VERSION);
    @Nullable
    private final String saslMechanismName = this.getString(TextFormattedAccessLogFields.BIND_SASL_MECHANISM);

    public TextFormattedBindRequestAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedBindRequestAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        String authType = this.getString(TextFormattedAccessLogFields.BIND_AUTHENTICATION_TYPE);
        this.authenticationType = authType == null ? null : BindRequestAuthenticationType.forName(authType);
    }

    @Override
    @NotNull
    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.BIND;
    }

    @Override
    @Nullable
    public final BindRequestAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    @Nullable
    public final String getDN() {
        return this.dn;
    }

    @Override
    @Nullable
    public final String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    @Nullable
    public final String getSASLMechanismName() {
        return this.saslMechanismName;
    }
}

