/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1BitString;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.DecodedPrivateKey;
import com.unboundid.util.ssl.cert.DecodedPublicKey;
import com.unboundid.util.ssl.cert.PKCS10CertificateSigningRequest;
import com.unboundid.util.ssl.cert.PKCS10CertificateSigningRequestVersion;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import com.unboundid.util.ssl.cert.PKCS8PrivateKeyVersion;
import com.unboundid.util.ssl.cert.X509Certificate;
import com.unboundid.util.ssl.cert.X509CertificateExtension;
import com.unboundid.util.ssl.cert.X509CertificateVersion;
import java.math.BigInteger;
import java.util.List;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InternalCertHelper {
    private InternalCertHelper() {
    }

    @InternalUseOnly
    @NotNull
    public static X509Certificate createX509Certificate(@NotNull X509CertificateVersion version, @NotNull BigInteger serialNumber, @NotNull OID signatureAlgorithmOID, @Nullable ASN1Element signatureAlgorithmParameters, @NotNull ASN1BitString signatureValue, @NotNull DN issuerDN, long notBefore, long notAfter, @NotNull DN subjectDN, @NotNull OID publicKeyAlgorithmOID, @Nullable ASN1Element publicKeyAlgorithmParameters, @NotNull ASN1BitString encodedPublicKey, @Nullable DecodedPublicKey decodedPublicKey, @Nullable ASN1BitString issuerUniqueID, @Nullable ASN1BitString subjectUniqueID, X509CertificateExtension ... extensions) throws CertException {
        return new X509Certificate(version, serialNumber, signatureAlgorithmOID, signatureAlgorithmParameters, signatureValue, issuerDN, notBefore, notAfter, subjectDN, publicKeyAlgorithmOID, publicKeyAlgorithmParameters, encodedPublicKey, decodedPublicKey, issuerUniqueID, subjectUniqueID, extensions);
    }

    @InternalUseOnly
    @NotNull
    public static PKCS10CertificateSigningRequest createPKCS10CertificateSigningRequest(@NotNull PKCS10CertificateSigningRequestVersion version, @NotNull OID signatureAlgorithmOID, @Nullable ASN1Element signatureAlgorithmParameters, @NotNull ASN1BitString signatureValue, @NotNull DN subjectDN, @NotNull OID publicKeyAlgorithmOID, @Nullable ASN1Element publicKeyAlgorithmParameters, @NotNull ASN1BitString encodedPublicKey, @Nullable DecodedPublicKey decodedPublicKey, @Nullable List<ObjectPair<OID, ASN1Set>> nonExtensionAttributes, X509CertificateExtension ... extensions) throws CertException {
        return new PKCS10CertificateSigningRequest(version, signatureAlgorithmOID, signatureAlgorithmParameters, signatureValue, subjectDN, publicKeyAlgorithmOID, publicKeyAlgorithmParameters, encodedPublicKey, decodedPublicKey, nonExtensionAttributes, extensions);
    }

    @InternalUseOnly
    @NotNull
    public static PKCS8PrivateKey createPKCS8PrivateKey(@NotNull PKCS8PrivateKeyVersion version, @NotNull OID privateKeyAlgorithmOID, @Nullable ASN1Element privateKeyAlgorithmParameters, @NotNull ASN1OctetString encodedPrivateKey, @Nullable DecodedPrivateKey decodedPrivateKey, @Nullable ASN1Element attributesElement, @Nullable ASN1BitString publicKey) throws CertException {
        return new PKCS8PrivateKey(version, privateKeyAlgorithmOID, privateKeyAlgorithmParameters, encodedPrivateKey, decodedPrivateKey, attributesElement, publicKey);
    }
}

