/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.pulsar;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.pulsar.Auth;
import org.apache.james.backends.pulsar.Auth$NoAuth$;
import org.apache.james.backends.pulsar.Namespace;
import org.apache.james.backends.pulsar.PulsarConfiguration;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.ModuleSerializationProxy;

public final class PulsarConfiguration$
implements Serializable {
    public static final PulsarConfiguration$ MODULE$ = new PulsarConfiguration$();
    private static final String BROKER_URI_PROPERTY_NAME = "broker.uri";
    private static final String ADMIN_URI_PROPERTY_NAME = "admin.uri";
    private static final String NAMESPACE_PROPERTY_NAME = "namespace";
    private static final String AUTHENTICATION_TYPE_PROPERTY_NAME = "authentication.type";
    private static final String AUTHENTICATION_TYPE_NO_AUTH = "no-auth";
    private static final String AUTHENTICATION_TYPE_AUTH_TOKEN = "token";
    private static final String AUTHENTICATION_TYPE_AUTH_BASIC = "basic";
    private static final String AUTHENTICATION_TOKEN_PROPERTY_NAME = "authentication.token";
    private static final String AUTHENTICATION_BASIC_USERID_PROPERTY_NAME = "authentication.basic.userId";
    private static final String AUTHENTICATION_BASIC_PASSWORD_PROPERTY_NAME = "authentication.basic.password";

    public Auth $lessinit$greater$default$4() {
        return Auth$NoAuth$.MODULE$;
    }

    public String BROKER_URI_PROPERTY_NAME() {
        return BROKER_URI_PROPERTY_NAME;
    }

    public String ADMIN_URI_PROPERTY_NAME() {
        return ADMIN_URI_PROPERTY_NAME;
    }

    public String NAMESPACE_PROPERTY_NAME() {
        return NAMESPACE_PROPERTY_NAME;
    }

    public String AUTHENTICATION_TYPE_PROPERTY_NAME() {
        return AUTHENTICATION_TYPE_PROPERTY_NAME;
    }

    public String AUTHENTICATION_TYPE_NO_AUTH() {
        return AUTHENTICATION_TYPE_NO_AUTH;
    }

    public String AUTHENTICATION_TYPE_AUTH_TOKEN() {
        return AUTHENTICATION_TYPE_AUTH_TOKEN;
    }

    public String AUTHENTICATION_TYPE_AUTH_BASIC() {
        return AUTHENTICATION_TYPE_AUTH_BASIC;
    }

    public String AUTHENTICATION_TOKEN_PROPERTY_NAME() {
        return AUTHENTICATION_TOKEN_PROPERTY_NAME;
    }

    public String AUTHENTICATION_BASIC_USERID_PROPERTY_NAME() {
        return AUTHENTICATION_BASIC_USERID_PROPERTY_NAME;
    }

    public String AUTHENTICATION_BASIC_PASSWORD_PROPERTY_NAME() {
        return AUTHENTICATION_BASIC_PASSWORD_PROPERTY_NAME;
    }

    public PulsarConfiguration from(Configuration configuration) {
        Auth auth;
        String authTypeString;
        String brokerUri = this.extractUri(configuration, this.BROKER_URI_PROPERTY_NAME());
        String adminUri = this.extractUri(configuration, this.ADMIN_URI_PROPERTY_NAME());
        String string = authTypeString = configuration.getString(this.AUTHENTICATION_TYPE_PROPERTY_NAME(), this.AUTHENTICATION_TYPE_NO_AUTH());
        String string2 = this.AUTHENTICATION_TYPE_NO_AUTH();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            auth = Auth$NoAuth$.MODULE$;
        } else {
            String string4 = this.AUTHENTICATION_TYPE_AUTH_TOKEN();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                String token = configuration.getString(this.AUTHENTICATION_TOKEN_PROPERTY_NAME());
                if (Strings.isNullOrEmpty((String)token)) {
                    throw new IllegalStateException("You need to specify a non-empty value for " + this.AUTHENTICATION_TOKEN_PROPERTY_NAME());
                }
                auth = new Auth.Token(token);
            } else {
                String string6 = this.AUTHENTICATION_TYPE_AUTH_BASIC();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    String userId = configuration.getString(this.AUTHENTICATION_BASIC_USERID_PROPERTY_NAME());
                    if (Strings.isNullOrEmpty((String)userId)) {
                        throw new IllegalStateException("You need to specify a non-empty value for " + this.AUTHENTICATION_BASIC_USERID_PROPERTY_NAME());
                    }
                    String password = configuration.getString(this.AUTHENTICATION_BASIC_PASSWORD_PROPERTY_NAME());
                    if (Strings.isNullOrEmpty((String)password)) {
                        throw new IllegalStateException("You need to specify a non-empty value for " + this.AUTHENTICATION_BASIC_PASSWORD_PROPERTY_NAME());
                    }
                    auth = new Auth.Basic(userId, password);
                } else {
                    throw new NotImplementedError("Authentication type " + authTypeString + " is not implemented");
                }
            }
        }
        Auth$NoAuth$ auth2 = auth;
        String namespace = configuration.getString(this.NAMESPACE_PROPERTY_NAME());
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalStateException("You need to specify the pulsar namespace as " + this.NAMESPACE_PROPERTY_NAME());
        }
        return new PulsarConfiguration(brokerUri, adminUri, new Namespace(namespace), auth2);
    }

    private String extractUri(Configuration configuration, String uriPropertyName) {
        String extractedUri = configuration.getString(uriPropertyName);
        if (Strings.isNullOrEmpty((String)extractedUri)) {
            throw new IllegalStateException("You need to specify the pulsar " + uriPropertyName + " uri");
        }
        try {
            new URI(extractedUri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("'" + extractedUri + "' is not a valid " + uriPropertyName + " uri", ex);
        }
        return extractedUri;
    }

    public PulsarConfiguration apply(String brokerUri, String adminUri, Namespace namespace, Auth auth) {
        return new PulsarConfiguration(brokerUri, adminUri, namespace, auth);
    }

    public Auth apply$default$4() {
        return Auth$NoAuth$.MODULE$;
    }

    public Option<Tuple4<String, String, Namespace, Auth>> unapply(PulsarConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.brokerUri(), (Object)x$0.adminUri(), (Object)x$0.namespace(), (Object)x$0.auth()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PulsarConfiguration$.class);
    }

    private PulsarConfiguration$() {
    }
}

