/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.streams;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class Offset {
    private static final Offset NONE = new Offset(0);
    private final int offset;

    public static Offset from(Optional<Integer> offset) {
        return offset.map(Offset::from).orElse(NONE);
    }

    public static Offset none() {
        return NONE;
    }

    public static Offset from(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset should be positive");
        return new Offset(offset);
    }

    private Offset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public final boolean equals(Object o) {
        if (o instanceof Offset) {
            Offset other = (Offset)o;
            return Objects.equals(this.offset, other.offset);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.offset);
    }
}

