/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.api.model.Size$;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UTCDate$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailMetadata;
import org.apache.james.jmap.mail.EmailMetadataView;
import org.apache.james.jmap.mail.EmailViewFactory;
import org.apache.james.jmap.mail.Keywords;
import org.apache.james.jmap.mail.MailboxIds;
import org.apache.james.jmap.method.ZoneIdProvider;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.util.html.HtmlTextExtractor;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00154A\u0001B\u0003\u0005!!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011\u00053G\u0001\rF[\u0006LG.T3uC\u0012\fG/\u0019,jK^4\u0015m\u0019;pefT!AB\u0004\u0002\t5\f\u0017\u000e\u001c\u0006\u0003\u0011%\tAA[7ba*\u0011!bC\u0001\u0006U\u0006lWm\u001d\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\tr\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VM\u001a\t\u00041eYR\"A\u0003\n\u0005i)!\u0001E#nC&dg+[3x\r\u0006\u001cGo\u001c:z!\tAB$\u0003\u0002\u001e\u000b\t\tR)\\1jY6+G/\u00193bi\u00064\u0016.Z<\u0002\u001di|g.Z%e!J|g/\u001b3feB\u0011\u0001eI\u0007\u0002C)\u0011!eB\u0001\u0007[\u0016$\bn\u001c3\n\u0005\u0011\n#A\u0004.p]\u0016LE\r\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dB\u0003C\u0001\r\u0001\u0011\u0015q\"\u00011\u0001 Q\t\u0011!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u00051\u0011N\u001c6fGRT\u0011aL\u0001\bU\u0006\\\u0017M\u001d;b\u0013\t\tDF\u0001\u0004J]*,7\r^\u0001\bi>,U.Y5m)\r!t\u000b\u0019\u000b\u0003km\u00022AN\u001d\u001c\u001b\u00059$B\u0001\u001d\u0014\u0003\u0011)H/\u001b7\n\u0005i:$a\u0001+ss\")Ah\u0001a\u0001{\u00059Q.Z:tC\u001e,\u0007\u0003\u0002\n?\u0001\"K!aP\n\u0003\rQ+\b\u000f\\33!\t\te)D\u0001C\u0015\t\u0019E)A\u0003n_\u0012,GN\u0003\u0002F\u0013\u00059Q.Y5mE>D\u0018BA$C\u0005%iUm]:bO\u0016LE\rE\u0002J#Rs!AS(\u000f\u0005-sU\"\u0001'\u000b\u00055{\u0011A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t\u00016#A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001b&aA*fc*\u0011\u0001k\u0005\t\u0003\u0003VK!A\u0016\"\u0003\u001b5+7o]1hKJ+7/\u001e7u\u0011\u0015A6\u00011\u0001Z\u0003EAG/\u001c7UKb$X\t\u001f;sC\u000e$xN\u001d\t\u00035zk\u0011a\u0017\u0006\u00039v\u000bA\u0001\u001b;nY*\u0011\u0001(C\u0005\u0003?n\u0013\u0011\u0003\u0013;nYR+\u0007\u0010^#yiJ\f7\r^8s\u0011\u0015\t7\u00011\u0001c\u0003\u001d\u0011X-];fgR\u0004\"\u0001G2\n\u0005\u0011,!aD#nC&dw)\u001a;SKF,Xm\u001d;")
public class EmailMetadataViewFactory
implements EmailViewFactory<EmailMetadataView> {
    private final ZoneIdProvider zoneIdProvider;

    @Override
    public Try<EmailMetadataView> toEmail(HtmlTextExtractor htmlTextExtractor, EmailGetRequest request, Tuple2<MessageId, Seq<MessageResult>> message) {
        MessageId messageId = (MessageId)message._1();
        MailboxIds mailboxIds = new MailboxIds((List<MailboxId>)((IterableOnceOps)((IterableOps)message._2()).map((Function1 & Serializable)x$17 -> x$17.getMailboxId())).toList());
        String threadId = ((MessageResult)((IterableOps)message._2()).head()).getThreadId().serialize();
        return ((Try)((IterableOps)message._2()).headOption().map((Function1 & Serializable)x$18 -> new Success(x$18)).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("No message supplied")))).flatMap((Function1 & Serializable)firstMessage -> BlobId$.MODULE$.of(messageId).flatMap((Function1 & Serializable)blobId -> Email$.MODULE$.mergeKeywords((Seq<MessageResult>)((Seq)message._2())).map((Function1 & Serializable)keywords -> {
            MessageId x$1 = messageId;
            BlobId x$2 = blobId;
            String x$3 = threadId;
            Keywords x$4 = keywords;
            MailboxIds x$5 = mailboxIds;
            UTCDate x$6 = UTCDate$.MODULE$.from(firstMessage.getInternalDate(), $this.zoneIdProvider.get());
            Long x$7 = Size$.MODULE$.sanitizeSize(firstMessage.getSize());
            return new EmailMetadataView(new EmailMetadata(x$1, x$2, x$3, x$4, x$5, x$7, x$6));
        })));
    }

    @Inject
    public EmailMetadataViewFactory(ZoneIdProvider zoneIdProvider) {
        this.zoneIdProvider = zoneIdProvider;
    }
}

