/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.MaxSizeRequest$;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.RequestObject;
import org.apache.james.jmap.core.ResponseObject;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.UserProvisioning;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.JMAPApi;
import org.apache.james.jmap.routes.JMAPApiRoutes$;
import org.apache.james.jmap.routes.RequestSizeExceeded;
import org.apache.james.jmap.routes.StreamConstraintsExceptionWithInput;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.util.context.ContextView;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tMq!\u0002\r\u001a\u0011\u0003!c!\u0002\u0014\u001a\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%\t!\r\u0005\u0007q\u0005\u0001\u000b\u0011\u0002\u001a\t\u000fe\n!\u0019!C\u0001u!1a)\u0001Q\u0001\nmBQaR\u0001\u0005\u0002!3AAJ\r\u00011\"AQ\r\u0003BC\u0002\u0013\u0005a\r\u0003\u0005n\u0011\t\u0005\t\u0015!\u0003h\u0011!q\u0007B!A!\u0002\u0013y\u0007\u0002\u0003:\t\u0005\u0003\u0005\u000b\u0011B:\t\u000b9BA\u0011\u0001<\t\riAA\u0011IA\f\u0011\u001d\ty\u0003\u0003C\u0005\u0003cAaa\u0012\u0005\u0005\n\u00055\u0004bBA9\u0011\u0011%\u00111\u000f\u0005\b\u0003\u001bCA\u0011BAH\u0011\u001d\ty\u000b\u0003C\u0005\u0003cCq!a,\t\t\u0013\t9\fC\u0004\u0002V\"!I!a6\t\u000f\u0005E\b\u0002\"\u0003\u0002t\"9!1\u0001\u0005\u0005\n\t\u0015\u0011!\u0004&N\u0003B\u000b\u0005/\u001b*pkR,7O\u0003\u0002\u001b7\u00051!o\\;uKNT!\u0001H\u000f\u0002\t)l\u0017\r\u001d\u0006\u0003=}\tQA[1nKNT!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u0001\u0001CA\u0013\u0002\u001b\u0005I\"!\u0004&N\u0003B\u000b\u0005/\u001b*pkR,7o\u0005\u0002\u0002QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0013\u0002\r1{uiR#S+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\"\u0003\u0015\u0019HN\u001a\u001bk\u0013\t9DG\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0003Iy%+S$J\u001d\u0006cu,\u0013)`\u0011\u0016\u000bE)\u0012*\u0016\u0003m\u0002\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 +\u001b\u0005y$B\u0001!$\u0003\u0019a$o\\8u}%\u0011!IK\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002CU\u0005\u0019rJU%H\u0013:\u000bEjX%Q?\"+\u0015\tR#SA\u00059R\r\u001f;sC\u000e$xJ]5hS:\fGn\u00117jK:$\u0018\n\u0015\u000b\u0003w%CQAS\u0004A\u0002m\n\u0001c\u001c:jO&t\u0017\r\\%q\u0011\u0016\fG-\u001a:)\u0005\u001da\u0005CA'W\u001b\u0005q%BA(Q\u0003-\tgN\\8uCRLwN\\:\u000b\u0005E\u0013\u0016AB2p[6|gN\u0003\u0002T)\u00061qm\\8hY\u0016T\u0011!V\u0001\u0004G>l\u0017BA,O\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\n\u0004\u0011e\u000b\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011a\u0017M\\4\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\t\u001cW\"A\u000e\n\u0005\u0011\\\"A\u0003&N\u0003B\u0013v.\u001e;fg\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003Un\tA\u0001\u001b;ua&\u0011A.\u001b\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005yQo]3s!J|g/[:j_:,'\u000f\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u0011+N,'\u000f\u0015:pm&\u001c\u0018n\u001c8j]\u001e\fqA[7ba\u0006\u0003\u0018\u000e\u0005\u0002&i&\u0011Q/\u0007\u0002\b\u00156\u000b\u0005+\u00119j)\u00199\b0a\u0003\u0002\u000eA\u0011Q\u0005\u0003\u0005\u0006K6\u0001\ra\u001a\u0015\u0007qj\f)!a\u0002\u0011\u0007m\f\t!D\u0001}\u0015\tih0\u0001\u0004j]*,7\r\u001e\u0006\u0002\u007f\u00069!.Y6beR\f\u0017bAA\u0002y\n)a*Y7fI\u0006)a/\u00197vK\u0006\u0012\u0011\u0011B\u0001\t%\u001a\u001bU\u0006\u000f\u001c3c!)a.\u0004a\u0001_\")!/\u0004a\u0001g\"\u001aQ\"!\u0005\u0011\u0007m\f\u0019\"C\u0002\u0002\u0016q\u0014a!\u00138kK\u000e$HCAA\r!\u0019\tY\"!\n\u0002*5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0004tiJ,\u0017-\u001c\u0006\u0004\u0003Gi\u0016\u0001B;uS2LA!a\n\u0002\u001e\t11\u000b\u001e:fC6\u00042AYA\u0016\u0013\r\tic\u0007\u0002\n\u00156\u000b\u0005KU8vi\u0016\fA\u0001]8tiR1\u00111GA'\u0003G\u0002b!!\u000e\u0002D\u0005\u001dSBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0013A,(\r\\5tQ\u0016\u0014(\u0002BA\u001f\u0003\u007f\tAaY8sK*\u0011\u0011\u0011I\u0001\be\u0016\f7\r^8s\u0013\u0011\t)%a\u000e\u0003\t5{gn\u001c\t\u00045\u0006%\u0013bAA&7\n!ak\\5e\u0011\u001d\tye\u0004a\u0001\u0003#\n\u0011\u0003\u001b;uaN+'O^3s%\u0016\fX/Z:u!\u0011\t\u0019&a\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\naa]3sm\u0016\u0014(b\u00016\u0002\\)!\u0011QLA \u0003\u0015qW\r\u001e;z\u0013\u0011\t\t'!\u0016\u0003#!#H\u000f]*feZ,'OU3rk\u0016\u001cH\u000fC\u0004\u0002f=\u0001\r!a\u001a\u0002%!$H\u000f]*feZ,'OU3ta>t7/\u001a\t\u0005\u0003'\nI'\u0003\u0003\u0002l\u0005U#A\u0005%uiB\u001cVM\u001d<feJ+7\u000f]8og\u0016$2aOA8\u0011\u001d\ty\u0005\u0005a\u0001\u0003#\n1C]3rk\u0016\u001cH/Q:Kg>t7\u000b\u001e:fC6$B!!\u001e\u0002\fB1\u0011qOA?\u0003\u0003k!!!\u001f\u000b\t\u0005e\u00121\u0010\u0006\u0004W\u0005m\u0012\u0002BA@\u0003s\u0012QaU'p]>\u0004B!a!\u0002\b6\u0011\u0011Q\u0011\u0006\u0004\u0003{Y\u0012\u0002BAE\u0003\u000b\u0013QBU3rk\u0016\u001cHo\u00142kK\u000e$\bbBA(#\u0001\u0007\u0011\u0011K\u0001\u0014m\u0006d\u0017\u000eZ1uKJ+\u0017/^3tiNK'0Z\u000b\u0003\u0003#\u0003\u0012\"KAJ\u0003/\u000b\u0019+!+\n\u0007\u0005U%FA\u0005Gk:\u001cG/[8oeA)\u0011&!'\u0002\u001e&\u0019\u00111\u0014\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0007%\ny*C\u0002\u0002\"*\u0012AAQ=uKB1\u0011QGAS\u0003/KA!a*\u00028\ty1+\u001f8dQJ|gn\\;t'&t7\u000eE\u0002*\u0003WK1!!,+\u0005\u0011)f.\u001b;\u0002%A\f'o]3SKF,Xm\u001d;PE*,7\r^\u000b\u0003\u0003g\u0003\u0012\"KAJ\u0003/\u000b),!+\u0011\r\u0005U\u0012QUAA)\u0011\tI,!5\u0011\u0011\u0005m\u0016QYAf\u0003\u0003sA!!0\u0002B:\u0019a(a0\n\u0003-J1!a1+\u0003\u001d\u0001\u0018mY6bO\u0016LA!a2\u0002J\n1Q)\u001b;iKJT1!a1+!\u0011\tY,!4\n\t\u0005=\u0017\u0011\u001a\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t\u0007bBAj)\u0001\u0007\u0011qS\u0001\u0006S:\u0004X\u000f^\u0001\baJ|7-Z:t)!\tI.a7\u0002`\u0006\u0005\bCBA<\u0003{\n9\u0005C\u0004\u0002^V\u0001\r!!!\u0002\u001bI,\u0017/^3ti>\u0013'.Z2u\u0011\u001d\t)'\u0006a\u0001\u0003OBq!a9\u0016\u0001\u0004\t)/\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\t\u0005\u001d\u0018Q^\u0007\u0003\u0003ST1!a;\u001e\u0003\u001di\u0017-\u001b7c_bLA!a<\u0002j\nqQ*Y5mE>D8+Z:tS>t\u0017a\u00035b]\u0012dW-\u0012:s_J$b!!7\u0002v\u0006}\bbBA|-\u0001\u0007\u0011\u0011`\u0001\ni\"\u0014xn^1cY\u0016\u0004B!a/\u0002|&!\u0011Q`Ae\u0005%!\u0006N]8xC\ndW\rC\u0004\u0003\u0002Y\u0001\r!a\u001a\u0002\u0011I,7\u000f]8og\u0016\faB]3ta>tG\rR3uC&d7\u000f\u0006\u0004\u0002Z\n\u001d!\u0011\u0002\u0005\b\u0003K:\u0002\u0019AA4\u0011\u001d\u0011Ya\u0006a\u0001\u0005\u001b\tq\u0001Z3uC&d7\u000f\u0005\u0003\u0002\u0004\n=\u0011\u0002\u0002B\t\u0003\u000b\u0013a\u0002\u0015:pE2,W\u000eR3uC&d7\u000f")
public class JMAPApiRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final UserProvisioning userProvisioner;
    private final JMAPApi jmapApi;

    public static String ORIGINAL_IP_HEADER() {
        return JMAPApiRoutes$.MODULE$.ORIGINAL_IP_HEADER();
    }

    public static Logger LOGGER() {
        return JMAPApiRoutes$.MODULE$.LOGGER();
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.POST, (String)"/jmap")).action((httpServerRequest, httpServerResponse) -> this.post(httpServerRequest, httpServerResponse)).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)"/jmap")).action(JMAPRoutes.CORS_CONTROL).corsHeaders()});
    }

    private Mono<Void> post(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse) {
        return SMono$.MODULE$.apply((Publisher)this.authenticator().authenticate(httpServerRequest)).flatMap((Function1 & Serializable)mailboxSession -> $this.userProvisioner.provisionUser((MailboxSession)mailboxSession).then().then(this.requestAsJsonStream(httpServerRequest).flatMap((Function1 & Serializable)requestObject -> this.process((RequestObject)requestObject, httpServerResponse, (MailboxSession)mailboxSession)))).onErrorResume((Function1 & Serializable)throwable -> this.handleError((Throwable)throwable, httpServerResponse)).asJava().then().contextWrite((ContextView)ReactorUtils.context((String)"MDCBuilder.IP", (MDCBuilder)MDCBuilder.create().addToContext("ip", (String)Option$.MODULE$.apply((Object)httpServerRequest.hostAddress()).map((Function1 & Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable)() -> "")).addToContext(JMAPApiRoutes$.MODULE$.ORIGINAL_IP_HEADER(), this.extractOriginalClientIP(httpServerRequest)).addToContext("User-Agent", (String)Option$.MODULE$.apply((Object)httpServerRequest.requestHeaders().get("User-Agent")).getOrElse((Function0 & Serializable)() -> ""))));
    }

    private String extractOriginalClientIP(HttpServerRequest httpServerRequest) {
        return JMAPApiRoutes$.MODULE$.extractOriginalClientIP(httpServerRequest.requestHeaders().get(JMAPApiRoutes$.MODULE$.ORIGINAL_IP_HEADER()));
    }

    private SMono<RequestObject> requestAsJsonStream(HttpServerRequest httpServerRequest) {
        return SMono$.MODULE$.fromPublisher((Publisher)httpServerRequest.receive().aggregate().asByteArray()).handle(this.validateRequestSize()).handle(this.parseRequestObject());
    }

    private Function2<byte[], SynchronousSink<byte[]>, BoxedUnit> validateRequestSize() {
        return (Function2 & Serializable)(x0$1, x1$1) -> {
            JMAPApiRoutes.$anonfun$validateRequestSize$1(x0$1, x1$1);
            return BoxedUnit.UNIT;
        };
    }

    private Function2<byte[], SynchronousSink<RequestObject>, BoxedUnit> parseRequestObject() {
        return (Function2 & Serializable)(x0$1, x1$1) -> {
            JMAPApiRoutes.$anonfun$parseRequestObject$1(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        };
    }

    private Either<IllegalArgumentException, RequestObject> parseRequestObject(byte[] input) {
        JsResult<RequestObject> jsResult = ResponseSerializer$.MODULE$.deserializeRequestObject(input);
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            RequestObject requestObject = (RequestObject)jsSuccess.value();
            return new Right((Object)requestObject);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            return new Left((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        }
        throw new MatchError(jsResult);
    }

    private SMono<Void> process(RequestObject requestObject, HttpServerResponse httpServerResponse, MailboxSession mailboxSession) {
        return this.jmapApi.process(requestObject, mailboxSession).map((Function1 & Serializable)responseObject -> ResponseSerializer$.MODULE$.serialize((ResponseObject)responseObject)).map((Function1 & Serializable)json -> Json$.MODULE$.stringify(json)).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private SMono<Void> handleError(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            return this.respondDetails(unauthorizedException.addHeaders(response), ProblemDetails$.MODULE$.forThrowable(throwable));
        }
        return this.respondDetails(response, ProblemDetails$.MODULE$.forThrowable(throwable));
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$3 -> x$3.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    public static final /* synthetic */ void $anonfun$validateRequestSize$1(byte[] x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            byte[] input = (byte[])tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            if ((long)input.length > MaxSizeRequest$.MODULE$.DEFAULT()) {
                sink.error((Throwable)new RequestSizeExceeded(input));
                return;
            }
            sink.next((Object)input);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$parseRequestObject$5(SynchronousSink sink$1, byte[] input$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof StreamConstraintsException) {
            StreamConstraintsException streamConstraintsException = (StreamConstraintsException)throwable;
            sink$1.error((Throwable)new StreamConstraintsExceptionWithInput(streamConstraintsException, input$1));
            return;
        }
        sink$1.error(throwable);
    }

    public static final /* synthetic */ void $anonfun$parseRequestObject$6(BoxedUnit nothing) {
    }

    public static final /* synthetic */ void $anonfun$parseRequestObject$1(JMAPApiRoutes $this, byte[] x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            byte[] input = (byte[])tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.parseRequestObject(input).fold((Function1 & Serializable)x$1 -> {
                sink.error(x$1);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)x$1 -> {
                sink.next((Object)x$1);
                return BoxedUnit.UNIT;
            })).fold((Function1 & Serializable)x0$2 -> {
                JMAPApiRoutes.$anonfun$parseRequestObject$5(sink, input, x0$2);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)nothing -> {
                JMAPApiRoutes.$anonfun$parseRequestObject$6(nothing);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public JMAPApiRoutes(@Named(value="RFC-8621") Authenticator authenticator, UserProvisioning userProvisioner, JMAPApi jmapApi) {
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.jmapApi = jmapApi;
    }
}

