/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import org.apache.james.events.NamingStrategy;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RegistrationQueueName;
import org.apache.james.events.RoutingKeyConverter;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.Sender;

class RegistrationBinder {
    private final NamingStrategy namingStrategy;
    private final Sender sender;
    private final RegistrationQueueName registrationQueue;

    RegistrationBinder(NamingStrategy namingStrategy, Sender sender, RegistrationQueueName registrationQueue) {
        this.namingStrategy = namingStrategy;
        this.sender = sender;
        this.registrationQueue = registrationQueue;
    }

    Mono<Void> bind(RegistrationKey key) {
        return this.sender.bind(this.bindingSpecification(key)).then();
    }

    Mono<Void> unbind(RegistrationKey key) {
        return this.sender.unbind(this.bindingSpecification(key)).then();
    }

    private BindingSpecification bindingSpecification(RegistrationKey key) {
        RoutingKeyConverter.RoutingKey routingKey = RoutingKeyConverter.RoutingKey.of(key);
        return BindingSpecification.binding().exchange(this.namingStrategy.exchange()).queue(this.registrationQueue.asString()).routingKey(routingKey.asString());
    }
}

