/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.FixedBitSet;

public abstract class SortedSetDocValuesReaderState
implements Accountable {
    public static final int INVALID_ORDINAL = -1;

    protected SortedSetDocValuesReaderState() {
    }

    public abstract SortedSetDocValues getDocValues() throws IOException;

    public abstract String getField();

    public abstract IndexReader getReader();

    public abstract int getSize();

    public abstract FacetsConfig getFacetsConfig();

    public abstract OrdRange getOrdRange(String var1);

    public abstract Map<String, OrdRange> getPrefixToOrdRange();

    public abstract DimTree getDimTree(String var1);

    public abstract Iterable<String> getDims();

    public static final class DimTree {
        private final FixedBitSet hasChildren;
        private final int[] siblings;
        public final int dimStartOrd;

        public DimTree(int dimStartOrd, List<Integer> sibling, List<Boolean> hasChildren) {
            if (sibling.size() != hasChildren.size()) {
                throw new IllegalArgumentException("Sibling list and children list must have the same size. Got sibling list size of " + sibling.size() + " and child list size of " + hasChildren.size());
            }
            this.hasChildren = new FixedBitSet(hasChildren.size());
            this.siblings = new int[sibling.size()];
            for (int i = 0; i < sibling.size(); ++i) {
                if (hasChildren.get(i).booleanValue()) {
                    assert (i < sibling.size() - 1);
                    this.hasChildren.set(i);
                }
                assert (this.siblings[i] < sibling.size());
                this.siblings[i] = sibling.get(i);
            }
            this.dimStartOrd = dimStartOrd;
        }

        public PrimitiveIterator.OfInt iterator() {
            return this.iterator(this.dimStartOrd);
        }

        public PrimitiveIterator.OfInt iterator(final int pathOrd) {
            return new PrimitiveIterator.OfInt(){
                boolean atStart = true;
                int currentOrd;
                {
                    this.currentOrd = pathOrd - dimStartOrd;
                }

                @Override
                public int nextInt() {
                    if (this.atStart) {
                        if (this.currentOrd < 0 || this.currentOrd >= hasChildren.length()) {
                            return -1;
                        }
                        this.atStart = false;
                        if (hasChildren.get(this.currentOrd)) {
                            ++this.currentOrd;
                            return this.currentOrd + dimStartOrd;
                        }
                        return -1;
                    }
                    this.currentOrd = siblings[this.currentOrd];
                    return this.currentOrd + dimStartOrd;
                }

                @Override
                public boolean hasNext() {
                    if (this.atStart) {
                        if (this.currentOrd < 0 || this.currentOrd >= hasChildren.length()) {
                            return false;
                        }
                        return hasChildren.get(this.currentOrd);
                    }
                    return siblings[this.currentOrd] != -1;
                }
            };
        }
    }

    public record OrdRange(int start, int end) {
        public PrimitiveIterator.OfInt iterator() {
            return new PrimitiveIterator.OfInt(){
                int current;
                {
                    this.current = start;
                }

                @Override
                public int nextInt() {
                    if (this.current > end) {
                        return -1;
                    }
                    return this.current++;
                }

                @Override
                public boolean hasNext() {
                    return this.current <= end;
                }
            };
        }
    }
}

