/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.index;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingCodecReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.packed.PackedInts;

public final class BPIndexReorderer {
    private static final int TERM_IDS_BLOCK_SIZE = 17;
    private static final int FORK_THRESHOLD = 8192;
    public static final int DEFAULT_MIN_DOC_FREQ = 4096;
    public static final int DEFAULT_MIN_PARTITION_SIZE = 32;
    public static final int DEFAULT_MAX_ITERS = 20;
    private int minDocFreq;
    private float maxDocFreq;
    private int minPartitionSize;
    private int maxIters;
    private double ramBudgetMB;
    private Set<String> fields;
    private static final float[] LOG2_TABLE = new float[256];

    public BPIndexReorderer() {
        this.setMinDocFreq(4096);
        this.setMaxDocFreq(1.0f);
        this.setMinPartitionSize(32);
        this.setMaxIters(20);
        this.setRAMBudgetMB((double)Runtime.getRuntime().totalMemory() / 1024.0 / 1024.0 / 10.0);
        this.setFields(null);
    }

    public void setMinDocFreq(int minDocFreq) {
        if (minDocFreq < 1) {
            throw new IllegalArgumentException("minDocFreq must be at least 1, got " + minDocFreq);
        }
        this.minDocFreq = minDocFreq;
    }

    public void setMaxDocFreq(float maxDocFreq) {
        if (!(maxDocFreq > 0.0f) || !(maxDocFreq <= 1.0f)) {
            throw new IllegalArgumentException("maxDocFreq must be in (0, 1], got " + maxDocFreq);
        }
        this.maxDocFreq = maxDocFreq;
    }

    public void setMinPartitionSize(int minPartitionSize) {
        if (minPartitionSize < 1) {
            throw new IllegalArgumentException("minPartitionSize must be at least 1, got " + minPartitionSize);
        }
        this.minPartitionSize = minPartitionSize;
    }

    public void setMaxIters(int maxIters) {
        if (maxIters < 1) {
            throw new IllegalArgumentException("maxIters must be at least 1, got " + maxIters);
        }
        this.maxIters = maxIters;
    }

    public void setRAMBudgetMB(double ramBudgetMB) {
        this.ramBudgetMB = ramBudgetMB;
    }

    public void setFields(Set<String> fields) {
        this.fields = fields == null ? null : Set.copyOf(fields);
    }

    private int writePostings(CodecReader reader, Set<String> fields, Directory tempDir, DataOutput postingsOut, int parallelism) throws IOException {
        int maxNumTerms = (int)((this.ramBudgetMB * 1024.0 * 1024.0 - (double)BPIndexReorderer.docRAMRequirements(reader.maxDoc())) / (double)parallelism / (double)BPIndexReorderer.termRAMRequirementsPerThreadPerTerm());
        int maxDocFreq = (int)((double)this.maxDocFreq * (double)reader.maxDoc());
        int numTerms = 0;
        for (String field : fields) {
            long maxPossibleDocFreq;
            Terms terms = reader.terms(field);
            if (terms == null || terms.size() != -1L && (maxPossibleDocFreq = 1L + terms.getSumDocFreq() - terms.size()) < (long)this.minDocFreq) continue;
            TermsEnum iterator = terms.iterator();
            PostingsEnum postings = null;
            BytesRef term = iterator.next();
            while (term != null) {
                int docFreq = iterator.docFreq();
                if (docFreq >= this.minDocFreq && docFreq <= maxDocFreq) {
                    if (numTerms >= ArrayUtil.MAX_ARRAY_LENGTH) {
                        throw new IllegalArgumentException("Cannot perform recursive graph bisection on more than " + ArrayUtil.MAX_ARRAY_LENGTH + " terms, the maximum array length");
                    }
                    if (numTerms >= maxNumTerms) {
                        throw new NotEnoughRAMException("Too many terms are matching given the RAM budget of " + this.ramBudgetMB + "MB. Consider raising the RAM budget, raising the minimum doc frequency, or decreasing concurrency");
                    }
                    int termID = numTerms++;
                    postings = iterator.postings(postings, 0);
                    int doc = postings.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        postingsOut.writeLong(Integer.toUnsignedLong(termID) << 32 | Integer.toUnsignedLong(doc));
                        doc = postings.nextDoc();
                    }
                }
                term = iterator.next();
            }
        }
        return numTerms;
    }

    private ForwardIndex buildForwardIndex(Directory tempDir, String postingsFileName, final int maxDoc, final int maxTerm) throws IOException {
        String startOffsetsFileName;
        String termIDsFileName;
        IndexOutput startOffsets;
        try (final IndexOutput termIDs = tempDir.createTempOutput("term-ids", "", IOContext.DEFAULT);){
            startOffsets = tempDir.createTempOutput("start-offsets", "", IOContext.DEFAULT);
            try {
                termIDsFileName = termIDs.getName();
                startOffsetsFileName = startOffsets.getName();
                final int[] buffer = new int[17];
                new ForwardIndexSorter(tempDir).sortAndConsume(postingsFileName, maxDoc, new LongConsumer(){
                    int prevDoc = -1;
                    int bufferLen = 0;

                    @Override
                    public void accept(long value) throws IOException {
                        int doc = (int)value;
                        int termID = (int)(value >>> 32);
                        if (doc != this.prevDoc) {
                            if (this.bufferLen != 0) {
                                BPIndexReorderer.writeMonotonicInts(buffer, this.bufferLen, (DataOutput)termIDs);
                                this.bufferLen = 0;
                            }
                            assert (doc > this.prevDoc);
                            for (int d = this.prevDoc + 1; d <= doc; ++d) {
                                startOffsets.writeLong(termIDs.getFilePointer());
                            }
                            this.prevDoc = doc;
                        }
                        assert (termID < maxTerm) : termID + " " + maxTerm;
                        if (this.bufferLen == buffer.length) {
                            BPIndexReorderer.writeMonotonicInts(buffer, this.bufferLen, (DataOutput)termIDs);
                            this.bufferLen = 0;
                        }
                        buffer[this.bufferLen++] = termID;
                    }

                    @Override
                    public void onFinish() throws IOException {
                        if (this.bufferLen != 0) {
                            BPIndexReorderer.writeMonotonicInts(buffer, this.bufferLen, (DataOutput)termIDs);
                        }
                        for (int d = this.prevDoc + 1; d <= maxDoc; ++d) {
                            startOffsets.writeLong(termIDs.getFilePointer());
                        }
                        CodecUtil.writeFooter((IndexOutput)termIDs);
                        CodecUtil.writeFooter((IndexOutput)startOffsets);
                    }
                });
            }
            finally {
                if (startOffsets != null) {
                    startOffsets.close();
                }
            }
        }
        IndexInput termIDsInput = tempDir.openInput(termIDsFileName, IOContext.DEFAULT);
        startOffsets = tempDir.openInput(startOffsetsFileName, IOContext.DEFAULT);
        return new ForwardIndex((IndexInput)startOffsets, termIDsInput, maxTerm);
    }

    public Sorter.DocMap computeDocMap(CodecReader reader, Directory tempDir, Executor executor) throws IOException {
        if ((double)BPIndexReorderer.docRAMRequirements(reader.maxDoc()) >= this.ramBudgetMB * 1024.0 * 1024.0) {
            throw new NotEnoughRAMException("At least " + Math.ceil((double)BPIndexReorderer.docRAMRequirements(reader.maxDoc()) / 1024.0 / 1024.0) + "MB of RAM are required to hold metadata about documents in RAM, but current RAM budget is " + this.ramBudgetMB + "MB");
        }
        Set<String> fields = this.fields;
        if (fields == null) {
            fields = new HashSet<String>();
            for (FieldInfo fi : reader.getFieldInfos()) {
                if (fi.getIndexOptions() == IndexOptions.NONE) continue;
                fields.add(fi.name);
            }
        }
        TaskExecutor taskExecutor = executor == null ? null : new TaskExecutor(executor);
        final int[] newToOld = this.computePermutation(reader, fields, tempDir, taskExecutor);
        final int[] oldToNew = new int[newToOld.length];
        for (int i = 0; i < newToOld.length; ++i) {
            oldToNew[newToOld[i]] = i;
        }
        return new Sorter.DocMap(this){

            public int size() {
                return newToOld.length;
            }

            public int oldToNew(int docID) {
                return oldToNew[docID];
            }

            public int newToOld(int docID) {
                return newToOld[docID];
            }
        };
    }

    public CodecReader reorder(CodecReader reader, Directory tempDir, Executor executor) throws IOException {
        Sorter.DocMap docMap = this.computeDocMap(reader, tempDir, executor);
        return SortingCodecReader.wrap((CodecReader)reader, (Sorter.DocMap)docMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] computePermutation(CodecReader reader, Set<String> fields, Directory dir, TaskExecutor executor) throws IOException {
        int[] nArray;
        block13: {
            IndexOutput postingsOutput;
            ForwardIndex forwardIndex;
            TrackingDirectoryWrapper trackingDir;
            block12: {
                trackingDir = new TrackingDirectoryWrapper(dir);
                int parallelism = executor == null ? 1 : Runtime.getRuntime().availableProcessors();
                int maxDoc = reader.maxDoc();
                forwardIndex = null;
                postingsOutput = null;
                boolean success = false;
                try {
                    postingsOutput = trackingDir.createTempOutput("postings", "", IOContext.DEFAULT);
                    final int numTerms = this.writePostings(reader, fields, (Directory)trackingDir, (DataOutput)postingsOutput, parallelism);
                    CodecUtil.writeFooter((IndexOutput)postingsOutput);
                    postingsOutput.close();
                    final ForwardIndex finalForwardIndex = forwardIndex = this.buildForwardIndex((Directory)trackingDir, postingsOutput.getName(), maxDoc, numTerms);
                    trackingDir.deleteFile(postingsOutput.getName());
                    postingsOutput = null;
                    int[] sortedDocs = new int[maxDoc];
                    for (int i = 0; i < maxDoc; ++i) {
                        sortedDocs[i] = i;
                    }
                    BitSet parents = null;
                    String parentField = reader.getFieldInfos().getParentField();
                    if (parentField != null) {
                        parents = BitSet.of((DocIdSetIterator)DocValues.getNumeric((LeafReader)reader, (String)parentField), (int)maxDoc);
                    }
                    try (CloseableThreadLocal<PerThreadState> threadLocal = new CloseableThreadLocal<PerThreadState>(this){

                        protected PerThreadState initialValue() {
                            return new PerThreadState(numTerms, finalForwardIndex.clone());
                        }
                    };){
                        IntsRef docs = new IntsRef(sortedDocs, 0, sortedDocs.length);
                        new IndexReorderingTask(docs, new float[maxDoc], threadLocal, parents, executor, 0).call();
                    }
                    success = true;
                    nArray = sortedDocs;
                    if (!success) break block12;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{forwardIndex});
                        IOUtils.deleteFiles((Directory)trackingDir, (Collection)trackingDir.getCreatedFiles());
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsOutput, forwardIndex});
                        IOUtils.deleteFilesIgnoringExceptions((Directory)trackingDir, (Collection)trackingDir.getCreatedFiles());
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{forwardIndex});
                IOUtils.deleteFiles((Directory)trackingDir, (Collection)trackingDir.getCreatedFiles());
                break block13;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsOutput, forwardIndex});
            IOUtils.deleteFilesIgnoringExceptions((Directory)trackingDir, (Collection)trackingDir.getCreatedFiles());
        }
        return nArray;
    }

    private static boolean sorted(IntsRef intsRef) {
        for (int i = 1; i < intsRef.length; ++i) {
            if (intsRef.ints[intsRef.offset + i - 1] <= intsRef.ints[intsRef.offset + i]) continue;
            return false;
        }
        return true;
    }

    private static long docRAMRequirements(int maxDoc) {
        return 8L * (long)maxDoc;
    }

    private static long termRAMRequirementsPerThreadPerTerm() {
        return 8L;
    }

    static float fastLog2(int i) {
        assert (i > 0) : "Cannot compute log of i=" + i;
        int floorLog2 = 31 - Integer.numberOfLeadingZeros(i);
        int tableIndex = i << 32 - floorLog2 >>> 24;
        return (float)floorLog2 + LOG2_TABLE[tableIndex];
    }

    static void writeMonotonicInts(int[] ints, int len, DataOutput out) throws IOException {
        assert (len > 0);
        assert (len <= 17);
        if (len >= 3 && ints[len - 1] - ints[0] <= 65535) {
            int i;
            int i2 = 1;
            while (i2 < len) {
                int n = i2++;
                ints[n] = ints[n] - ints[0];
            }
            int numPacked = (len - 1) / 2;
            int encodedLen = 1 + len / 2;
            for (i = 0; i < numPacked; ++i) {
                int n = 1 + i;
                ints[n] = ints[n] | ints[encodedLen + i] << 16;
            }
            out.writeByte((byte)(len << 1 | 1));
            for (i = 0; i < encodedLen; ++i) {
                out.writeInt(ints[i]);
            }
        } else {
            out.writeByte((byte)(len << 1));
            for (int i = 0; i < len; ++i) {
                out.writeInt(ints[i]);
            }
        }
    }

    static int readMonotonicInts(DataInput in, int[] ints) throws IOException {
        boolean packed;
        int token = in.readByte() & 0xFF;
        int len = token >>> 1;
        boolean bl = packed = (token & 1) != 0;
        if (packed) {
            int i;
            int encodedLen = 1 + len / 2;
            in.readInts(ints, 0, encodedLen);
            int numPacked = (len - 1) / 2;
            for (i = 0; i < numPacked; ++i) {
                ints[encodedLen + i] = ints[1 + i] >>> 16;
                int n = 1 + i;
                ints[n] = ints[n] & 0xFFFF;
            }
            i = 1;
            while (i < len) {
                int n = i++;
                ints[n] = ints[n] + ints[0];
            }
        } else {
            in.readInts(ints, 0, len);
        }
        return len;
    }

    static {
        BPIndexReorderer.LOG2_TABLE[0] = 1.0f;
        int one = Float.floatToIntBits(1.0f);
        for (int i = 0; i < 256; ++i) {
            float f = Float.intBitsToFloat(one | i << 15);
            BPIndexReorderer.LOG2_TABLE[i] = (float)(Math.log(f) / Math.log(2.0));
        }
    }

    public static class NotEnoughRAMException
    extends RuntimeException {
        private NotEnoughRAMException(String message) {
            super(message);
        }
    }

    static class ForwardIndexSorter {
        private static final int HISTOGRAM_SIZE = 256;
        private static final int BUFFER_SIZE = 8192;
        private static final int BUFFER_BYTES = 65536;
        private final Directory directory;
        private final Bucket[] buckets = new Bucket[256];

        private static long encode(long fpDelta) {
            assert ((fpDelta & 7L) == 0L) : "fpDelta should be multiple of 8";
            if (fpDelta % 65536L == 0L) {
                return fpDelta / 65536L << 1 | 1L;
            }
            return fpDelta;
        }

        private static long decode(long fpDelta) {
            if ((fpDelta & 1L) == 1L) {
                return (fpDelta >>> 1) * 65536L;
            }
            return fpDelta;
        }

        ForwardIndexSorter(Directory directory) {
            this.directory = directory;
            for (int i = 0; i < 256; ++i) {
                this.buckets[i] = new Bucket();
            }
        }

        private void consume(String fileName, LongConsumer consumer) throws IOException {
            try (IndexInput in = this.directory.openInput(fileName, IOContext.READONCE);){
                long end = in.length() - (long)CodecUtil.footerLength();
                while (in.getFilePointer() < end) {
                    consumer.accept(in.readLong());
                }
            }
            consumer.onFinish();
        }

        private void consume(String fileName, long indexFP, LongConsumer consumer) throws IOException {
            try (IndexInput index = this.directory.openInput(fileName, IOContext.READONCE);
                 IndexInput value = this.directory.openInput(fileName, IOContext.READONCE);){
                index.seek(indexFP);
                for (int i = 0; i < this.buckets.length; ++i) {
                    int blockNum = index.readVInt();
                    int finalBlockSize = index.readVInt();
                    long fp = ForwardIndexSorter.decode(index.readVLong());
                    for (int block = 0; block < blockNum - 1; ++block) {
                        value.seek(fp);
                        for (int j = 0; j < 8192; ++j) {
                            consumer.accept(value.readLong());
                        }
                        fp += ForwardIndexSorter.decode(index.readVLong());
                    }
                    value.seek(fp);
                    for (int j = 0; j < finalBlockSize; ++j) {
                        consumer.accept(value.readLong());
                    }
                }
                consumer.onFinish();
            }
        }

        private LongConsumer consumer(final int shift) {
            return new LongConsumer(){

                @Override
                public void accept(long value) throws IOException {
                    int b = (int)(value >>> shift & 0xFFL);
                    Bucket bucket = buckets[b];
                    bucket.addEntry(value);
                }

                @Override
                public void onFinish() throws IOException {
                    for (Bucket bucket : buckets) {
                        bucket.flush(true);
                    }
                }
            };
        }

        void sortAndConsume(String fileName, int maxDoc, LongConsumer consumer) throws IOException {
            int bitsRequired = PackedInts.bitsRequired((long)maxDoc);
            String sourceFileName = fileName;
            long indexFP = -1L;
            for (int shift = 0; shift < bitsRequired; shift += 8) {
                try (IndexOutput output = this.directory.createTempOutput(fileName, "sort", IOContext.DEFAULT);){
                    Arrays.stream(this.buckets).forEach(b -> b.reset(output));
                    if (shift == 0) {
                        this.consume(sourceFileName, this.consumer(shift));
                    } else {
                        this.consume(sourceFileName, indexFP, this.consumer(shift));
                        this.directory.deleteFile(sourceFileName);
                    }
                    indexFP = output.getFilePointer();
                    for (Bucket bucket : this.buckets) {
                        output.writeVInt(bucket.blockNum);
                        output.writeVInt(bucket.finalBlockSize);
                        bucket.fps.copyTo((DataOutput)output);
                    }
                    CodecUtil.writeFooter((IndexOutput)output);
                    sourceFileName = output.getName();
                    continue;
                }
            }
            this.consume(sourceFileName, indexFP, consumer);
        }

        private static class Bucket {
            private final ByteBuffersDataOutput fps = new ByteBuffersDataOutput();
            private final long[] buffer = new long[8192];
            private IndexOutput output;
            private int bufferUsed;
            private int blockNum;
            private long lastFp;
            private int finalBlockSize;

            private Bucket() {
            }

            private void addEntry(long l) throws IOException {
                this.buffer[this.bufferUsed++] = l;
                if (this.bufferUsed == 8192) {
                    this.flush(false);
                }
            }

            private void flush(boolean isFinal) throws IOException {
                if (isFinal) {
                    this.finalBlockSize = this.bufferUsed;
                }
                long fp = this.output.getFilePointer();
                this.fps.writeVLong(ForwardIndexSorter.encode(fp - this.lastFp));
                this.lastFp = fp;
                for (int i = 0; i < this.bufferUsed; ++i) {
                    this.output.writeLong(this.buffer[i]);
                }
                this.lastFp = fp;
                ++this.blockNum;
                this.bufferUsed = 0;
            }

            private void reset(IndexOutput resetOutput) {
                this.output = resetOutput;
                this.finalBlockSize = 0;
                this.bufferUsed = 0;
                this.blockNum = 0;
                this.lastFp = 0L;
                this.fps.reset();
            }
        }
    }

    static interface LongConsumer {
        public void accept(long var1) throws IOException;

        default public void onFinish() throws IOException {
        }
    }

    private static final class ForwardIndex
    implements Cloneable,
    Closeable {
        private final RandomAccessInput startOffsets;
        private final IndexInput startOffsetsInput;
        private final IndexInput terms;
        private final int maxTerm;
        private long endOffset = -1L;
        private final int[] buffer = new int[17];
        private final IntsRef bufferRef = new IntsRef(this.buffer, 0, 0);

        ForwardIndex(IndexInput startOffsetsInput, IndexInput terms, int maxTerm) {
            this.startOffsetsInput = startOffsetsInput;
            try {
                this.startOffsets = startOffsetsInput.randomAccessSlice(0L, startOffsetsInput.length() - (long)CodecUtil.footerLength());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.terms = terms;
            this.maxTerm = maxTerm;
        }

        void seek(int docID) throws IOException {
            long startOffset = this.startOffsets.readLong((long)docID * 8L);
            this.endOffset = this.startOffsets.readLong(((long)docID + 1L) * 8L);
            this.terms.seek(startOffset);
        }

        IntsRef nextTerms() throws IOException {
            if (this.terms.getFilePointer() >= this.endOffset) {
                assert (this.terms.getFilePointer() == this.endOffset);
                this.bufferRef.length = 0;
            } else {
                this.bufferRef.length = BPIndexReorderer.readMonotonicInts((DataInput)this.terms, this.buffer);
            }
            return this.bufferRef;
        }

        public ForwardIndex clone() {
            return new ForwardIndex(this.startOffsetsInput.clone(), this.terms.clone(), this.maxTerm);
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.startOffsetsInput, this.terms});
        }
    }

    private class IndexReorderingTask
    extends BaseRecursiveAction {
        private final IntsRef docIDs;
        private final float[] biases;
        private final CloseableThreadLocal<PerThreadState> threadLocal;
        private final BitSet parents;

        IndexReorderingTask(IntsRef docIDs, float[] biases, CloseableThreadLocal<PerThreadState> threadLocal, BitSet parents, TaskExecutor executor, int depth) {
            super(BPIndexReorderer.this, executor, depth);
            this.docIDs = docIDs;
            this.biases = biases;
            this.threadLocal = threadLocal;
            this.parents = parents;
        }

        private static void computeDocFreqs(IntsRef docs, ForwardIndex forwardIndex, int[] docFreqs) {
            try {
                Arrays.fill(docFreqs, 0);
                int end = docs.offset + docs.length;
                for (int i = docs.offset; i < end; ++i) {
                    int doc = docs.ints[i];
                    forwardIndex.seek(doc);
                    IntsRef terms = forwardIndex.nextTerms();
                    while (terms.length != 0) {
                        for (int j = 0; j < terms.length; ++j) {
                            int termID;
                            int n = termID = terms.ints[terms.offset + j];
                            docFreqs[n] = docFreqs[n] + 1;
                        }
                        terms = forwardIndex.nextTerms();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public Void call() {
            if (this.depth > 0) {
                Arrays.sort(this.docIDs.ints, this.docIDs.offset, this.docIDs.offset + this.docIDs.length);
            } else assert (BPIndexReorderer.sorted(this.docIDs));
            assert (this.assertParentStructure());
            int halfLength = this.docIDs.length / 2;
            if (halfLength < BPIndexReorderer.this.minPartitionSize) {
                return null;
            }
            IntsRef left = new IntsRef(this.docIDs.ints, this.docIDs.offset, halfLength);
            IntsRef right = new IntsRef(this.docIDs.ints, this.docIDs.offset + halfLength, this.docIDs.length - halfLength);
            PerThreadState state = (PerThreadState)this.threadLocal.get();
            ForwardIndex forwardIndex = state.forwardIndex;
            int[] leftDocFreqs = state.leftDocFreqs;
            int[] rightDocFreqs = state.rightDocFreqs;
            IndexReorderingTask.computeDocFreqs(left, forwardIndex, leftDocFreqs);
            IndexReorderingTask.computeDocFreqs(right, forwardIndex, rightDocFreqs);
            for (int iter = 0; iter < BPIndexReorderer.this.maxIters; ++iter) {
                boolean moved;
                try {
                    moved = this.shuffle(forwardIndex, this.docIDs, right.offset, leftDocFreqs, rightDocFreqs, this.biases, this.parents, iter);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (!moved) break;
            }
            if (this.parents != null) {
                int lastLeftDocID = this.docIDs.ints[right.offset - 1];
                int split = right.offset + this.parents.nextSetBit(lastLeftDocID) - lastLeftDocID;
                if (split == this.docIDs.offset + this.docIDs.length && (split = right.offset - (lastLeftDocID - this.parents.prevSetBit(lastLeftDocID))) == this.docIDs.offset) {
                    return null;
                }
                assert (this.parents.get(this.docIDs.ints[split - 1]));
                left = new IntsRef(this.docIDs.ints, this.docIDs.offset, split - this.docIDs.offset);
                right = new IntsRef(this.docIDs.ints, split, this.docIDs.offset + this.docIDs.length - split);
            }
            IndexReorderingTask leftTask = new IndexReorderingTask(left, this.biases, this.threadLocal, this.parents, this.executor, this.depth + 1);
            IndexReorderingTask rightTask = new IndexReorderingTask(right, this.biases, this.threadLocal, this.parents, this.executor, this.depth + 1);
            if (this.shouldFork(this.docIDs.length, this.docIDs.ints.length)) {
                this.invokeAll(leftTask, rightTask);
            } else {
                leftTask.call();
                rightTask.call();
            }
            return null;
        }

        private boolean assertParentStructure() {
            int i;
            int numChildren;
            if (this.parents == null) {
                return true;
            }
            int end = this.docIDs.offset + this.docIDs.length;
            for (i = this.docIDs.offset; i < end; i += numChildren + 1) {
                int firstChild = this.docIDs.ints[i];
                int parent = this.parents.nextSetBit(firstChild);
                numChildren = parent - firstChild;
                assert (i + numChildren < end);
                for (int j = 1; j <= numChildren; ++j) {
                    assert (this.docIDs.ints[i + j] == firstChild + j) : "Parent structure has not been preserved";
                }
            }
            assert (i == end) : "Last doc ID must be a parent doc";
            return true;
        }

        private boolean shuffle(final ForwardIndex forwardIndex, final IntsRef docIDs, final int midPoint, final int[] leftDocFreqs, final int[] rightDocFreqs, final float[] biases, BitSet parents, int iter) throws IOException {
            new ComputeBiasTask(docIDs.ints, biases, docIDs.offset, docIDs.offset + docIDs.length, leftDocFreqs, rightDocFreqs, this.threadLocal, this.executor, this.depth).call();
            if (parents != null) {
                int numChildren;
                int end = docIDs.offset + docIDs.length;
                for (int i = docIDs.offset; i < end; i += numChildren + 1) {
                    int firstChild = docIDs.ints[i];
                    numChildren = parents.nextSetBit(firstChild) - firstChild;
                    assert (parents.get(docIDs.ints[i + numChildren]));
                    double cumulativeBias = 0.0;
                    for (int j = 0; j <= numChildren; ++j) {
                        cumulativeBias += (double)biases[i + j];
                    }
                    Arrays.fill(biases, i, i + numChildren + 1, (float)cumulativeBias);
                }
            }
            float maxLeftBias = Float.NEGATIVE_INFINITY;
            for (int i = docIDs.offset; i < midPoint; ++i) {
                maxLeftBias = Math.max(maxLeftBias, biases[i]);
            }
            float minRightBias = Float.POSITIVE_INFINITY;
            int end = docIDs.offset + docIDs.length;
            for (int i = midPoint; i < end; ++i) {
                minRightBias = Math.min(minRightBias, biases[i]);
            }
            float gain = maxLeftBias - minRightBias;
            if (gain <= (float)iter) {
                return false;
            }
            class Selector
            extends IntroSelector {
                int pivotDoc;
                float pivotBias;

                Selector() {
                }

                public void setPivot(int i) {
                    this.pivotDoc = docIDs.ints[i];
                    this.pivotBias = biases[i];
                }

                public int comparePivot(int j) {
                    int cmp = Float.compare(this.pivotBias, biases[j]);
                    if (cmp == 0) {
                        cmp = this.pivotDoc - docIDs.ints[j];
                    }
                    return cmp;
                }

                public void swap(int i, int j) {
                    float tmpBias = biases[i];
                    biases[i] = biases[j];
                    biases[j] = tmpBias;
                    if (i < midPoint == j < midPoint) {
                        int tmpDoc = docIDs.ints[i];
                        docIDs.ints[i] = docIDs.ints[j];
                        docIDs.ints[j] = tmpDoc;
                    } else {
                        int left = Math.min(i, j);
                        int right = Math.max(i, j);
                        try {
                            IndexReorderingTask.swapDocsAndFreqs(docIDs.ints, left, right, forwardIndex, leftDocFreqs, rightDocFreqs);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                }
            }
            final Selector selector = new Selector();
            if (parents == null) {
                selector.select(docIDs.offset, docIDs.offset + docIDs.length, midPoint);
            } else {
                new IntroSorter(this){
                    {
                    }

                    protected void setPivot(int i) {
                        selector.setPivot(i);
                    }

                    protected int comparePivot(int j) {
                        return selector.comparePivot(j);
                    }

                    protected void swap(int i, int j) {
                        selector.swap(i, j);
                    }
                }.sort(docIDs.offset, docIDs.offset + docIDs.length);
            }
            return true;
        }

        private static void swapDocsAndFreqs(int[] docs, int left, int right, ForwardIndex forwardIndex, int[] leftDocFreqs, int[] rightDocFreqs) throws IOException {
            int termID;
            int i;
            assert (left < right);
            int leftDoc = docs[left];
            int rightDoc = docs[right];
            forwardIndex.seek(leftDoc);
            IntsRef terms = forwardIndex.nextTerms();
            while (terms.length != 0) {
                for (i = 0; i < terms.length; ++i) {
                    int n = termID = terms.ints[terms.offset + i];
                    leftDocFreqs[n] = leftDocFreqs[n] - 1;
                    int n2 = termID;
                    rightDocFreqs[n2] = rightDocFreqs[n2] + 1;
                }
                terms = forwardIndex.nextTerms();
            }
            forwardIndex.seek(rightDoc);
            terms = forwardIndex.nextTerms();
            while (terms.length != 0) {
                for (i = 0; i < terms.length; ++i) {
                    int n = termID = terms.ints[terms.offset + i];
                    leftDocFreqs[n] = leftDocFreqs[n] + 1;
                    int n3 = termID;
                    rightDocFreqs[n3] = rightDocFreqs[n3] - 1;
                }
                terms = forwardIndex.nextTerms();
            }
            docs[left] = rightDoc;
            docs[right] = leftDoc;
        }
    }

    private class ComputeBiasTask
    extends BaseRecursiveAction {
        private final int[] docs;
        private final float[] biases;
        private final int from;
        private final int to;
        private final int[] fromDocFreqs;
        private final int[] toDocFreqs;
        private final CloseableThreadLocal<PerThreadState> threadLocal;

        ComputeBiasTask(int[] docs, float[] biases, int from, int to, int[] fromDocFreqs, int[] toDocFreqs, CloseableThreadLocal<PerThreadState> threadLocal, TaskExecutor executor, int depth) {
            super(BPIndexReorderer.this, executor, depth);
            this.docs = docs;
            this.biases = biases;
            this.from = from;
            this.to = to;
            this.fromDocFreqs = fromDocFreqs;
            this.toDocFreqs = toDocFreqs;
            this.threadLocal = threadLocal;
        }

        @Override
        public Void call() {
            int problemSize = this.to - this.from;
            if (problemSize > 1 && this.shouldFork(problemSize, this.docs.length)) {
                int mid = this.from + this.to >>> 1;
                this.invokeAll(new ComputeBiasTask(this.docs, this.biases, this.from, mid, this.fromDocFreqs, this.toDocFreqs, this.threadLocal, this.executor, this.depth), new ComputeBiasTask(this.docs, this.biases, mid, this.to, this.fromDocFreqs, this.toDocFreqs, this.threadLocal, this.executor, this.depth));
            } else {
                ForwardIndex forwardIndex = ((PerThreadState)this.threadLocal.get()).forwardIndex;
                try {
                    for (int i = this.from; i < this.to; ++i) {
                        this.biases[i] = ComputeBiasTask.computeBias(this.docs[i], forwardIndex, this.fromDocFreqs, this.toDocFreqs);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return null;
        }

        private static float computeBias(int docID, ForwardIndex forwardIndex, int[] fromDocFreqs, int[] toDocFreqs) throws IOException {
            forwardIndex.seek(docID);
            double bias = 0.0;
            IntsRef terms = forwardIndex.nextTerms();
            while (terms.length != 0) {
                for (int i = 0; i < terms.length; ++i) {
                    int termID = terms.ints[terms.offset + i];
                    int fromDocFreq = fromDocFreqs[termID];
                    int toDocFreq = toDocFreqs[termID];
                    assert (fromDocFreq >= 0);
                    assert (toDocFreq >= 0);
                    bias += (double)((toDocFreq == 0 ? 0.0f : BPIndexReorderer.fastLog2(toDocFreq)) - (fromDocFreq == 0 ? 0.0f : BPIndexReorderer.fastLog2(fromDocFreq)));
                }
                terms = forwardIndex.nextTerms();
            }
            return (float)bias;
        }
    }

    private abstract class BaseRecursiveAction
    implements Callable<Void> {
        protected final TaskExecutor executor;
        protected final int depth;

        BaseRecursiveAction(BPIndexReorderer bPIndexReorderer, TaskExecutor executor, int depth) {
            this.executor = executor;
            this.depth = depth;
        }

        protected final boolean shouldFork(int problemSize, int totalProblemSize) {
            if (this.executor == null) {
                return false;
            }
            if (problemSize == totalProblemSize) {
                return true;
            }
            return problemSize > 8192;
        }

        @Override
        public abstract Void call();

        protected final void invokeAll(BaseRecursiveAction ... actions) {
            assert (this.executor != null) : "Only call invokeAll if shouldFork returned true";
            try {
                this.executor.invokeAll(Arrays.asList(actions));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class PerThreadState {
        final ForwardIndex forwardIndex;
        final int[] leftDocFreqs;
        final int[] rightDocFreqs;

        PerThreadState(int numTerms, ForwardIndex forwardIndex) {
            this.forwardIndex = forwardIndex;
            this.leftDocFreqs = new int[numTerms];
            this.rightDocFreqs = new int[numTerms];
        }
    }
}

