/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDelete;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class LDAPDeleteSearchListener
implements SearchResultListener {
    private static final long serialVersionUID = 2185398520482379634L;
    @NotNull
    private final AtomicReference<ResultCode> returnCode;
    @NotNull
    private final LDAPDelete ldapDelete;
    @NotNull
    private final String baseDN;
    @NotNull
    private final String filter;
    @NotNull
    private final TreeSet<DN> dnSet;

    LDAPDeleteSearchListener(@NotNull LDAPDelete ldapDelete, @NotNull TreeSet<DN> dnSet, @NotNull String baseDN, @NotNull String filter, @NotNull AtomicReference<ResultCode> returnCode) {
        this.ldapDelete = ldapDelete;
        this.baseDN = baseDN;
        this.filter = filter;
        this.dnSet = dnSet;
        this.returnCode = returnCode;
    }

    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        try {
            this.dnSet.add(searchEntry.getParsedDN());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.ldapDelete.commentToErr(ToolMessages.ERR_LDAPDELETE_SEARCH_LISTENER_CANNOT_PARSE_ENTRY_DN.get(this.baseDN, this.filter, searchEntry.getDN(), StaticUtils.getExceptionMessage(e)));
            this.returnCode.compareAndSet(null, e.getResultCode());
        }
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
        this.returnCode.compareAndSet(null, ResultCode.REFERRAL);
        this.ldapDelete.commentToErr(ToolMessages.ERR_LDAPDELETE_SEARCH_LISTENER_REFERENCE.get(this.baseDN, this.filter, String.valueOf(searchReference)));
    }
}

