/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertMessages;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum PKCS5AlgorithmIdentifier {
    PBES2("1.2.840.113549.1.5.13", "PBES2", Collections.emptySet(), CertMessages.INFO_PKCS5_ALG_ID_DESC_PBES2.get()),
    PBKDF2("1.2.840.113549.1.5.12", "PBKDF2", Collections.emptySet(), CertMessages.INFO_PKCS5_ALG_ID_DESC_PBKDF2.get()),
    HMAC_SHA_1("1.2.840.113549.2.7", "HMAC-SHA-1", StaticUtils.setOf("HMAC-SHA", "HmacSHA"), CertMessages.INFO_PKCS5_ALG_ID_DESC_HMAC_SHA_1.get()),
    HMAC_SHA_224("1.2.840.113549.2.8", "HMAC-SHA-224", StaticUtils.setOf("HmacSHA224"), CertMessages.INFO_PKCS5_ALG_ID_DESC_HMAC_SHA_224.get()),
    HMAC_SHA_256("1.2.840.113549.2.9", "HMAC-SHA-256", StaticUtils.setOf("HmacSHA256"), CertMessages.INFO_PKCS5_ALG_ID_DESC_HMAC_SHA_256.get()),
    HMAC_SHA_384("1.2.840.113549.2.10", "HMAC-SHA-384", StaticUtils.setOf("HmacSHA384"), CertMessages.INFO_PKCS5_ALG_ID_DESC_HMAC_SHA_384.get()),
    HMAC_SHA_512("1.2.840.113549.2.11", "HMAC-SHA-512", StaticUtils.setOf("HmacSHA512"), CertMessages.INFO_PKCS5_ALG_ID_DESC_HMAC_SHA_512.get()),
    DES_EDE3_CBC_PAD("1.2.840.113549.3.7", "DES-EDE3-CBC-PAD", StaticUtils.setOf("DES-EDE-CBC-PAD", "DES-EDE3-CBC", "DES-EDE-CBC", "DES-EDE3", "DESEDE3", "DES-EDE", "DESEDE", "3DES-CBC-PAD", "3DES-CBC", "3DES"), CertMessages.INFO_PKCS5_ALG_ID_DESC_DES_EDE_CBC_PAD.get()),
    AES_128_CBC_PAD("2.16.840.1.101.3.4.1.2", "AES-128-CBC-PAD", StaticUtils.setOf("AES128-CBC", "AES128", "AES", "AES/CBC/PKCS5Padding", "AES128/CBC/PKCS5Padding"), CertMessages.INFO_PKCS5_ALG_ID_DESC_AES_128_CBC_PAD.get()),
    AES_192_CBC_PAD("2.16.840.1.101.3.4.1.22", "AES-192-CBC-PAD", StaticUtils.setOf("AES192-CBC", "AES192", "AES192/CBC/PKCS5Padding"), CertMessages.INFO_PKCS5_ALG_ID_DESC_AES_192_CBC_PAD.get()),
    AES_256_CBC_PAD("2.16.840.1.101.3.4.1.42", "AES-256-CBC-PAD", StaticUtils.setOf("AES256-CBC", "AES256", "AES256/CBC/PKCS5Padding"), CertMessages.INFO_PKCS5_ALG_ID_DESC_AES_256_CBC_PAD.get());

    @NotNull
    private static final Map<PKCS5AlgorithmIdentifier, String> PSEUDORANDOM_FUNCTIONS;
    @NotNull
    private static final Map<PKCS5AlgorithmIdentifier, ObjectPair<String, Integer>> CIPHER_TRANSFORMATIONS;
    @NotNull
    private final OID oid;
    @NotNull
    private final Set<String> preparedNames;
    @NotNull
    private final String description;
    @NotNull
    private final String primaryName;

    private PKCS5AlgorithmIdentifier(@NotNull String oidString, @NotNull String primaryName, Set<String> alternativeNames, String description) {
        this.primaryName = primaryName;
        this.description = description;
        HashSet<String> preparedNameSet = new HashSet<String>();
        preparedNameSet.add(PKCS5AlgorithmIdentifier.prepareName(primaryName));
        for (String alternativeName : alternativeNames) {
            preparedNameSet.add(PKCS5AlgorithmIdentifier.prepareName(alternativeName));
        }
        this.preparedNames = Collections.unmodifiableSet(preparedNameSet);
        this.oid = new OID(oidString);
    }

    @NotNull
    public OID getOID() {
        return this.oid;
    }

    @NotNull
    public String getName() {
        return this.primaryName;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public static PKCS5AlgorithmIdentifier forOID(@NotNull OID oid) {
        for (PKCS5AlgorithmIdentifier v : PKCS5AlgorithmIdentifier.values()) {
            if (!v.oid.equals(oid)) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static PKCS5AlgorithmIdentifier forName(@NotNull String name) {
        String preparedName = PKCS5AlgorithmIdentifier.prepareName(name);
        for (PKCS5AlgorithmIdentifier v : PKCS5AlgorithmIdentifier.values()) {
            if (!v.preparedNames.contains(preparedName)) continue;
            return v;
        }
        return null;
    }

    @NotNull
    private static String prepareName(@NotNull String name) {
        StringBuilder buffer = new StringBuilder(name.length());
        block3: for (char c : name.toLowerCase().toCharArray()) {
            switch (c) {
                case ' ': 
                case '-': 
                case '/': 
                case '_': {
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    @NotNull
    public static String getNameOrOID(@NotNull OID oid) {
        PKCS5AlgorithmIdentifier id = PKCS5AlgorithmIdentifier.forOID(oid);
        if (id == null) {
            return oid.toString();
        }
        return id.primaryName;
    }

    @NotNull
    public static Set<PKCS5AlgorithmIdentifier> getPseudorandomFunctions() {
        return PSEUDORANDOM_FUNCTIONS.keySet();
    }

    @Nullable
    public static String getPBKDF2SecretKeyFactoryAlgorithmForPseudorandomFunction(@NotNull PKCS5AlgorithmIdentifier identifier) {
        return PSEUDORANDOM_FUNCTIONS.get((Object)identifier);
    }

    @NotNull
    public static Set<PKCS5AlgorithmIdentifier> getCipherTransformations() {
        return CIPHER_TRANSFORMATIONS.keySet();
    }

    @Nullable
    public static String getCipherAlgorithmName(@NotNull PKCS5AlgorithmIdentifier identifier) {
        ObjectPair<String, Integer> cipherTransformationPair = CIPHER_TRANSFORMATIONS.get((Object)identifier);
        if (cipherTransformationPair == null) {
            return null;
        }
        String cipherTransformationName = cipherTransformationPair.getFirst();
        int slashPos = cipherTransformationName.indexOf(47);
        return cipherTransformationName.substring(0, slashPos);
    }

    @Nullable
    public static String getCipherTransformationName(@NotNull PKCS5AlgorithmIdentifier identifier) {
        ObjectPair<String, Integer> cipherTransformationPair = CIPHER_TRANSFORMATIONS.get((Object)identifier);
        if (cipherTransformationPair == null) {
            return null;
        }
        return cipherTransformationPair.getFirst();
    }

    @Nullable
    public static Integer getCipherKeySizeBits(@NotNull PKCS5AlgorithmIdentifier identifier) {
        ObjectPair<String, Integer> cipherTransformationPair = CIPHER_TRANSFORMATIONS.get((Object)identifier);
        if (cipherTransformationPair == null) {
            return null;
        }
        return cipherTransformationPair.getSecond();
    }

    @NotNull
    public String toString() {
        return this.primaryName;
    }

    static {
        PSEUDORANDOM_FUNCTIONS = StaticUtils.mapOf(HMAC_SHA_1, "PBKDF2WithHmacSHA1", HMAC_SHA_224, "PBKDF2WithHmacSHA224", HMAC_SHA_256, "PBKDF2WithHmacSHA256", HMAC_SHA_384, "PBKDF2WithHmacSHA384", HMAC_SHA_512, "PBKDF2WithHmacSHA512");
        CIPHER_TRANSFORMATIONS = StaticUtils.mapOf(DES_EDE3_CBC_PAD, new ObjectPair<String, Integer>("DESede/CBC/PKCS5Padding", 192), AES_128_CBC_PAD, new ObjectPair<String, Integer>("AES/CBC/PKCS5Padding", 128), AES_192_CBC_PAD, new ObjectPair<String, Integer>("AES/CBC/PKCS5Padding", 192), AES_256_CBC_PAD, new ObjectPair<String, Integer>("AES/CBC/PKCS5Padding", 256));
    }
}

