/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum RSAPrivateKeyVersion {
    TWO_PRIME(0, "two-prime"),
    MULTI(1, "multi");

    private final int intValue;
    @NotNull
    private final String name;

    private RSAPrivateKeyVersion(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    int getIntValue() {
        return this.intValue;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    static RSAPrivateKeyVersion valueOf(int intValue) {
        for (RSAPrivateKeyVersion v : RSAPrivateKeyVersion.values()) {
            if (v.intValue != intValue) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static RSAPrivateKeyVersion forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "twoprime": 
            case "two-prime": 
            case "two_prime": {
                return TWO_PRIME;
            }
            case "multi": {
                return MULTI;
            }
        }
        return null;
    }
}

