/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.openjpa.jdbc.kernel.BatchingPreparedStatementManagerImpl;
import org.apache.openjpa.jdbc.kernel.ConstraintUpdateManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.util.OpenJPAException;

public class BatchingConstraintUpdateManager
extends ConstraintUpdateManager {
    @Override
    protected PreparedStatementManager newPreparedStatementManager(JDBCStore store, Connection conn) {
        int batchLimit = this.dict.getBatchLimit();
        return new BatchingPreparedStatementManagerImpl(store, conn, batchLimit);
    }

    @Override
    protected Collection flush(RowManager rowMgr, PreparedStatementManager psMgr, Collection exceps) {
        exceps = super.flush(rowMgr, psMgr, exceps);
        BatchingPreparedStatementManagerImpl bPsMgr = (BatchingPreparedStatementManagerImpl)psMgr;
        try {
            bPsMgr.flushBatch();
        }
        catch (SQLException se) {
            exceps = this.addException(exceps, SQLExceptions.getStore(se, this.dict));
        }
        catch (OpenJPAException ke) {
            exceps = this.addException(exceps, ke);
        }
        return exceps;
    }
}

